<?php

namespace App\Http\Controllers;

use App\Models\Loan;
use App\Models\Batchcode;
use App\Models\Payroll;
use Illuminate\Http\Request;
use Yajra\DataTables\DataTables;
use App\Models\PersonApprove;
use App\Models\PersonInCharge;

class LoanController extends Controller
{

    public function index(Request $request)
    {

        if ($request->ajax()) {

            $data = BatchCode::with('client')->get();

            return DataTables::of($data)

                ->addColumn('employee_count', function ($row) {

                    return Payroll::where('code_id', $row->id)
                        ->where('status', 0)
                        ->count();
                })
                ->addColumn('approve_by', function ($row) {
                    $user = PersonInCharge::with('user')->where('batch_id', $row->id)->first();
                    return $user && $user->user ? $user->user->name : 'N/A';
                })
                ->addColumn('approve_by1', function ($row) {
                    $user = PersonApprove::with('user')->where('batch_id', $row->id)->first();

                    if ($user && $user->user) {
                        return $user->user->name;
                    } else {
                        return 'Not Yet Approved'; // Show this when there is no user or approval data
                    }
                })
                ->addColumn('action', function ($row) {

                    return '<div class="flex items-center justify-center gap-2">
                        <a href="' . url('admin/payroll-deduction/' . $row->id . '/' . 0) . '" class="flex items-center justify-center w-10 h-10 text-white bg-green-600 rounded-md edit">
                            <i class="text-xl bx bx-show"></i>
                        </a>
                      
                    </div>';
                })
                ->make(true);
        }
        return view('Admin.Payroll.deduction.index');
    }
    public function viewpayroll(Request $request, $batch_id, $status)
    {
        $data = Batchcode::with('client')->find($batch_id);
        if ($request->ajax()) {
            // Fetch loans with associated payroll data
            $loanData = Loan::with(['payroll.client', 'payroll.batchCode', 'payroll.employee'])
                ->whereHas('payroll', function ($query) use ($batch_id, $status) {
                    $query->where('code_id', $batch_id)
                        ->where('status', $status);
                })
                ->get();

            return DataTables::of($loanData)
                ->addColumn('payroll_details', function ($row) {

                    $payroll = $row->payroll;
                    $middleInitial = $payroll->employee->middle_name ? substr($payroll->employee->middle_name, 0, 1) . '.' : '';
                    return $payroll->employee->first_name . ' ' . $middleInitial . ' ' . $payroll->employee->last_name;
                })
                ->addColumn('total', function ($row) {
                    $total = $row->capital + $row->loans + $row->c_loans + $row->mortuary;
                    return $total;
                })


                ->addColumn('action', function ($row) {
                    $payroll = $row->payroll;
                    $actionBtn = '<div class="flex items-center justify-center gap-2">';
                    if ($payroll->batchCode->status == 0) {
                        $actionBtn .= ' <a href="' . url('admin/pre-profile/' . $payroll->employee_id) . '" class="flex items-center justify-center w-10 h-10 text-white bg-green-600 rounded-md edit"><i class="text-xl bx bx-show"></i></a>
                        <button onclick="openEditModal(' . $row->id . ')" class="px-2 py-2 text-white bg-blue-500 rounded"><i class="text-xl bx bx-edit"></i></button>
                        <button onclick="confirmDeletePayroll(' . $row->id . ')" class="px-2 py-2 text-white bg-red-500 rounded"><i class="text-xl bx bx-trash"></i></button>';
                    } else {
                        $actionBtn .= ' <a href="' . url('admin/pre-profile/' . $payroll->employee_id) . '" class="flex items-center justify-center w-10 h-10 text-white bg-green-600 rounded-md edit"><i class="text-xl bx bx-show"></i></a>';
                    }
                    $actionBtn .= '</div>';
                    return $actionBtn;
                })
                ->make(true);
        }

        return view('Admin.Payroll.deduction.viewpayrolldeduction', compact('batch_id', 'status', 'data'));
    }


    public function create()
    {
        $payrolls = Payroll::all();
        return view('loans.create', compact('payrolls'));
    }



    public function store(Request $request)
    {
        $request->validate([
            'payroll_id' => 'required|exists:payrolls,id',
            'capital' => 'nullable|string',
            'loans' => 'nullable|string',
            'c_loans' => 'nullable|string',
            'mortuary' => 'nullable|string',
        ]);

        Loan::create($request->all());

        return redirect()->route('loans.index')->with('success', 'Loan record created successfully.');
    }

    // Show the form for editing the specified loan
    public function edit($id)
    {
        $loan = Loan::with('payroll.employee', 'payroll.client')->findOrFail($id);
        return response()->json($loan);
    }

    // Update the specified loan
    public function update(Request $request, $id)
    {
        $request->validate([
            'capital' => 'nullable|numeric',
            'loans' => 'nullable|numeric',
            'c_loans' => 'nullable|numeric',
            'mortuary' => 'nullable|numeric',
        ]);


        $loan = Loan::findOrFail($id);
        $loan->update($request->only(['capital', 'loans', 'c_loans', 'mortuary']));

        return response()->json(['message' => 'Deduction updated successfully', 'data' => $loan]);
    }

    // Remove the specified loan
    public function destroy(Loan $loan)
    {
        $loan->delete();

        return redirect()->route('loans.index')->with('success', 'Loan record deleted successfully.');
    }
}
