<?php

namespace App\Http\Controllers;

use App\Models\EmployeeClientChannel;
use App\Models\Employeerate;
use Illuminate\Http\Request;
use App\Models\DefaultRate;
use App\Models\MinimumWage;
use App\Models\EmployeeWageAssignment;
use Yajra\DataTables\DataTables;
use App\Models\Assign;
use App\Models\AssignCompany;
use App\Models\AssignCompanyDepartment;
use Illuminate\Support\Facades\Auth;
use Carbon\Carbon;
class EmployeeWageController extends Controller
{
    public function storerate(Request $request)
    {
        $request->validate([
            'name' => 'required|string|max:255',
            'default_rate' => 'required|numeric',
        ]);

        DefaultRate::create([
            'name' => $request->name,
            'default_rate' => $request->default_rate,
        ]);

        return response()->json(['message' => 'Rate created successfully']);
    }

    public function updaterate(Request $request, $id)
    {
        $request->validate([
            'name' => 'required|string|max:255',
            'default_rate' => 'required|numeric',
        ]);

        $rate = DefaultRate::findOrFail($id);
        $rate->update([
            'name' => $request->name,
            'default_rate' => $request->default_rate,
        ]);

        return response()->json(['message' => 'Rate updated successfully']);
    }

    public function index(Request $request)
    {
        return view('Admin.Employee.wage.index');
    }
    public function assign(Request $request)
    {
        $minimumWages = MinimumWage::with('default_rate')->where('status', 'Active')->get();
        return view('Admin.Employee.wage.assigntoemployee', compact('minimumWages'));
    }
    public function storeemployee(Request $request)
    {
        $request->validate([
            'minimum_wage_id' => 'required|exists:minimum_wages,id',
            'assignemployee_id' => 'required|array',
            'assignemployee_id.*' => 'exists:assignemployeee,id',
        ]);

        foreach ($request->assignemployee_id as $employeeId) {
            EmployeeWageAssignment::create(attributes: [
                'assignemployee_id' => $employeeId,
                'minimum_wage_id' => $request->minimum_wage_id,
                'status' => 1,
            ]);
        }

        return response()->json(['message' => 'Wage assignments saved successfully.']);
    }


    public function wage(Request $request)
    {
        if ($request->ajax()) {
            $data = MinimumWage::with('default_rate')->get();

            return DataTables::of($data)
                ->addColumn('date', function ($row) {
                    return $row->effective_date
                        ? \Carbon\Carbon::parse($row->effective_date)->format('F j, Y')
                        : 'N/A';
                })
                ->addColumn('action', function ($row) {
                    return '
                <div class="flex items-center justify-center gap-2">
                   
                    <button onclick="openDeleteModal(' . $row->id . ')" class="flex items-center justify-center w-10 h-10 text-white bg-red-600 rounded-md">
                        <i class="text-xl bx bx-trash-alt"></i>
                    </button>
                    
                </div>';
                })
                ->rawColumns(['action'])

                ->make(true);
        }
    }
    public function regiontable(Request $request)
    {
        if ($request->ajax()) {
            $data = DefaultRate::orderBy('created_at', 'desc')->get();
            return DataTables::of($data)
                ->addColumn('action', function ($row) {
                    $adjustment = MinimumWage::where('default_rate_id', $row->id)->exists();
                    $button = '<div class="flex items-center justify-center gap-2">';
                    // $button .= '<a href="' . url('admin/agency-profile/' . $row->id) . '" class="flex items-center justify-center w-10 h-10 text-white bg-green-600 rounded-md edit"><i class="text-xl bx bx-show"></i></a>';
    
                    if (!$adjustment) {
                        $button .= '<button onclick="openDeleteModal(' . $row->id . ')" class="flex items-center justify-center w-10 h-10 text-white bg-red-600 rounded-md">
                    <i class="text-xl bx bx-trash-alt"></i>
                </button>';
                    } else {
                        $button .= 'Unable to delete';
                    }
                    $button .= '</div>';
                    return $button;

                })
                ->rawColumns(['action'])
                ->make(true);

        }
        return view('Admin.Employee.wage.rate');
    }

    public function deletedefaultrate($id)
    {
        $data = DefaultRate::findOrFail($id);
        $data->delete();
        return response()->json([
            'success' => true,
            'message' => 'Record deleted successfully.'
        ]);
    }
    public function employeewages(Request $request)
    {
        $user = Auth::user();
        $agencyIds = $user->viewable_agency_ids;


        $query = EmployeeWageAssignment::with('employeeassign.department.client.agency', 'minimumWage.default_rate');


        if (!empty($agencyIds)) {

            $query->whereHas('employeeassign.department.client.agency', function ($q) use ($agencyIds) {
                $q->whereIn('id', $agencyIds);
            });


            $assignIds = Assign::where('user_id', $user->id)
                ->whereIn('agency_id', $agencyIds)
                ->pluck('id');

            $restrictedCompanyIds = AssignCompany::whereIn('assign_id', $assignIds)
                ->pluck('id');

            $restrictedDepartmentIds = AssignCompanyDepartment::whereIn('assigncompany_id', $restrictedCompanyIds)
                ->pluck('department_id')
                ->unique();



            if ($restrictedDepartmentIds->isNotEmpty()) {
                $query->whereHas('employeeassign', function ($q) use ($restrictedDepartmentIds) {
                    $q->whereIn('department_id', $restrictedDepartmentIds);
                });
            }
        }








        if ($request->ajax()) {
            $data = $query->get();

            return DataTables::of($data)

                ->addColumn('employee_name', function ($row) {

                    $employee = EmployeeClientChannel::with('employee')->find($row->assignemployee_id);
                    return ($employee->employee->first_name ?? '') . ' ' . ($employee->employee->middle_name ?? '') . ' ' . $employee->employee->last_name;
                })

                ->addColumn('current_salary', function ($row) {
                    $employee = EmployeeClientChannel::with('employee')->find($row->assignemployee_id);

                    $slary = Employeerate::where('status', 1)->where('employee_id', $employee->employee_id)->sum('daily_rate');
                    return $row->minimumWage->amount_added + $slary;
                })
                ->addColumn('agency_company_client', function ($row) {
                    $employee = EmployeeClientChannel::with('department.client.agency')->find($row->assignemployee_id);

                    $agency = $employee->department->client->agency->name ?? 'N/A';
                    $company = $employee->department->client->business_name ?? 'N/A';
                    $client = $employee->department->department_name ?? 'N/A';

                    return "$agency / $company / $client";
                })

                ->addColumn('region', function ($row) {
                    return $row->minimumWage->default_rate->name;
                })
                ->addColumn('adjustment', function ($row) {
                    return $row->minimumWage->amount_added;
                })
                ->addColumn('date', function ($row) {
                    return \Carbon\Carbon::parse($row->minimumWage->effective_date)->format('F j, Y');
                })
                ->addColumn('action', function ($row) {
                    return '
                <div class="flex items-center justify-center gap-2">
                   
                    <button onclick="openDeleteModal(' . $row->id . ')" class="flex items-center justify-center w-10 h-10 text-white bg-red-600 rounded-md">
                        <i class="text-xl bx bx-trash-alt"></i>
                    </button>
                </div>';
                })
                ->rawColumns(['action', 'region'])

                ->make(true);
        }
    }
    public function region(Request $request)
    {
        if ($request->ajax()) {
            $defaultRates = DefaultRate::all()->map(function ($rate) {
                $amountAddedTotal = MinimumWage::where('default_rate_id', $rate->id)
                    ->where('effective_date', '<=', now())
                    ->sum('amount_added');

                return [
                    'id' => $rate->id,
                    'name' => $rate->name,
                    'default_rate' => $rate->default_rate ?? 0,
                    'amount_added_total' => $amountAddedTotal,
                ];
            });

            return response()->json($defaultRates);
        }
    }

    public function store(Request $request)
    {
        $validated = $request->validate([
            'default_rate_id' => 'required|exists:default_rate,id',
            'amount_added' => 'required|numeric|min:0',
            'effective_date' => 'required|date',
        ]);

        $default_rate = DefaultRate::find($validated['default_rate_id']);

        $rate = MinimumWage::where('default_rate_id', $validated['default_rate_id'])
            ->where('status', 'Active')
            ->sum('amount');

        MinimumWage::where('default_rate_id', $validated['default_rate_id'])
            ->where('status', 'Active')
            ->update(['status' => 'Inactive']);

        $validated['status'] = 'Active';

        if ($rate == 0) {
            $validated['amount'] = $default_rate->default_rate + $validated['amount_added'];
        } else {
            $validated['amount'] = $rate + $validated['amount_added'];
        }

        $wage = MinimumWage::create($validated);

        return response()->json([
            'message' => 'Minimum wage saved successfully',
            'data' => $wage
        ], 201);
    }

    public function destroy(Request $request, $id)
    {
        $wage = MinimumWage::findOrFail($id);
        $wage->delete();

        if ($request->ajax()) {
            return response()->json(['success' => true, 'message' => 'A Record deleted successfully.']);
        }

        return redirect()->back()->with('success', 'Attendance and selfie deleted successfully.');
    }
    public function deleteemployeewage(Request $request, $id)
    {
        $wage = EmployeeWageAssignment::findOrFail($id);
        $wage->delete();

        if ($request->ajax()) {
            return response()->json(['success' => true, 'message' => 'A Record deleted successfully.']);
        }

        return redirect()->back()->with('success', 'Attendance and selfie deleted successfully.');
    }

    public function customeemployeelist(Request $request)
    {


        $user = Auth::user();

        $agencyIds = $user->viewable_agency_ids;

        $status = $request->get('status');

        $query = EmployeeClientChannel::with('employee.user', 'default_rate', 'department')->where('status', 1);


        if (!empty($agencyIds)) {

            $query->whereHas('department.client.agency', function ($q) use ($agencyIds) {
                $q->whereIn('id', $agencyIds);
            });

            $assignIds = Assign::where('user_id', $user->id)
                ->whereIn('agency_id', $agencyIds)
                ->pluck('id');

            $restrictedDepartmentIds = AssignCompanyDepartment::whereIn('assigncompany_id', AssignCompany::whereIn('assign_id', $assignIds)
                ->pluck('id'))
                ->pluck('department_id')
                ->unique();

            if ($restrictedDepartmentIds->isNotEmpty()) {
                $query->whereIn('department_id', $restrictedDepartmentIds);
            }
        }

        if ($request->has('office_id') && $request->office_id) {

            $office_id = $request->office_id;
            $query->whereHas('employee', function ($q) use ($office_id) {
                $q->where('office_id', $office_id);
            });
        }

        if ($request->has('store_id') && $request->store_id) {

            $store_id = $request->store_id;
            $query->whereHas('employee', function ($q) use ($store_id) {
                $q->where('store_id', $store_id);
            });
        }


        if ($request->has('pwd_filter')) {
            $pwdFilter = $request->pwd_filter;

            if ($pwdFilter == 'Not PWD') {
                // Filter employees where 'pwd' is NULL
                $query->whereHas('employee', function ($q) {
                    $q->whereNull('pwd');
                });
            } else {
                // Filter employees where 'pwd' equals the selected value
                $query->whereHas('employee', function ($q) use ($pwdFilter) {
                    $q->where('pwd', $pwdFilter);
                });
            }
        }

        if ($request->ajax()) {
            $data = $query->get();

            return DataTables::of($data)
                ->addColumn('rate', function ($row) {
                    $amountAddedTotal = MinimumWage::where('default_rate_id', $row->default_rate_id)
                        ->where('effective_date', '<=', Carbon::now())
                        ->sum('amount_added');

                    return $row->default_rate->default_rate ?? 0 + $amountAddedTotal;
                })
                ->addColumn('rate_name', function ($row) {



                    return $row->default_rate->name ?? null;
                })
                ->addColumn('employee_name', function ($row) {
                    return $row->employee->first_name . ' ' . ($row->employee->middle_name ?? '') . ' ' . $row->employee->last_name;
                })
                ->addColumn('client', function ($row) {

                    return $row->department ? $row->department->department_name : 'No Active Client';
                })
                ->addColumn('company', function ($row) {

                    return $row->department->client ? $row->department->client->business_name : 'No Active Client';
                })
                ->addColumn('agency', function ($row) {

                    return $row->department->client->agency ? $row->department->client->agency->name : 'No Active Client';
                })
                ->addColumn('status', function ($row) {
                    $status = '<div class="flex items-center justify-center">
                    <span class="w-3 h-3 bg-green-500 rounded-full"></span>
                    <span class="ml-2">Active</span>
                </div>';

                    return $status;
                })


                ->rawColumns(['action', 'action1', 'profile', 'status'])
                ->make(true);
        }
    }
    public function updatewage(Request $request)
    {
        $request->validate([
            'id' => 'required|exists:assignemployeee,id',
            'default_rate_id' => 'nullable|exists:default_rate,id',


        ]);

        $record = EmployeeClientChannel::findOrFail($request->id);
        $record->default_rate_id = $request->default_rate_id;
        $record->save();

        return response()->json(['message' => 'Data updated successfully!']);
    }





}
