<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\EmployeeFile;
use Yajra\DataTables\DataTables;
use Illuminate\Support\Facades\File;
use Illuminate\Support\Facades\Storage;
class EmployeeFileController extends Controller
{
    public function employeefile(Request $request, $id)
    {


        if ($request->ajax()) {
            $data = EmployeeFile::where('employee_id', $id)->get();

            return DataTables::of($data)
                ->addColumn('action', function ($row) {

                    $companyAssignRoute = route('get_companyassign', $row->id);

                    $actionBtn = '
                    <div class="flex items-center justify-center gap-2">
                         <button onclick="openDeletedocsModal(' . $row->id . ')" class="flex items-center justify-center w-10 h-10 text-white bg-red-600 rounded-md">
                        <i class="text-xl bx bx-trash-alt"></i>
                    </button>
                      
                    </div>';
                    return $actionBtn;
                })
                ->make(true);
        }

    }



    public function store(Request $request)
    {
        $validated = $request->validate([
            'employee_id' => 'required|exists:employees,id',
            'Name' => 'required|string',
            'file' => 'nullable|file|max:10240', // optional: limit size to 10MB
        ]);

        $filePath = null;

        // if ($request->hasFile('file')) {
        //     $file = $request->file('file');
        //     $fileName = time() . '.' . $file->getClientOriginalExtension();
        //     $destination = public_path('docs');
        //     $file->move($destination, $fileName);
        //     $filePath = 'docs/' . $fileName;
        // }

        if ($request->hasFile('file')) {


            $file = $request->file('file');
            $filePath = 'files/' . time() . '.' . $file->getClientOriginalExtension(); // Folder inside Space
            Storage::disk('spaces')->put($filePath, file_get_contents($file), 'public');
        }


        EmployeeFile::create([
            'employee_id' => $validated['employee_id'],
            'Name' => $validated['Name'], // consider renaming to 'name'
            'file' => $filePath,
        ]);

        return redirect()->back()->with('success', 'File uploaded and saved successfully.');
    }

    public function destroy($id)
    {
        $fileRecord = EmployeeFile::findOrFail($id);

        // Delete the file from the filesystem if it exists
        if ($fileRecord->file && File::exists(public_path($fileRecord->file))) {
            File::delete(public_path($fileRecord->file));
        }

        // Delete the record from the database
        $fileRecord->delete();

        return response()->json(['success' => 'File deleted successfully.']);
    }
}
