<?php

namespace App\Http\Controllers;

use App\Models\DefaultRate;
use App\Models\WorkSchedule;
use Carbon\Carbon;
use Illuminate\Support\Facades\Crypt;
use App\Models\User;
use App\Models\Leave;
use App\Models\Shift;
use App\Models\Assign;
use App\Models\Client;
use App\Models\Stores;
use App\Models\BankLog;
use App\Models\Offices;
use App\Models\TrxCode;
use App\Models\Employee;
use App\Models\Department;
use App\Models\BankProfile;
use App\Models\Requisition;
use App\Models\ClearanceLog;
use App\Models\CustomBraket;
use Illuminate\Http\Request;
use App\Models\AssignCompany;
use App\Imports\EmployeeImport;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Hash;
use Maatwebsite\Excel\Facades\Excel;
use App\Models\EmployeeClientChannel;
use App\Models\EmployeeFile;
use App\Models\AssignCompanyDepartment;
use Yajra\DataTables\Facades\DataTables;
use Illuminate\Support\Facades\Validator;
use Barryvdh\DomPDF\Facade\Pdf;
use Illuminate\Support\Facades\Storage;
class EmployeeController extends Controller
{

    public function employeeid($id)
    {
        $employee = EmployeeClientChannel::with('department.client.agency', 'employee')->findOrFail($id);

        $base64Image = null;

        if (!empty($employee->employee->profile)) {
            try {
                $profilePath = $employee->employee->profile; // e.g., 'profiles/1752649715.jpg'
                $imageContent = Storage::disk('spaces')->get($profilePath);
                $mimeType = Storage::disk('spaces')->mimeType($profilePath);
                $base64Image = 'data:' . $mimeType . ';base64,' . base64_encode($imageContent);
            } catch (\Exception $e) {
                // You can log or handle errors here
                $base64Image = null;
            }
        }

        return Pdf::loadView('Admin.Employee.idcard', [
            'employee' => $employee,
            'base64Image' => $base64Image,
        ])->download('EmployeeID.pdf');
    }
    public function destroylogsclearance($logId)
    {
        // Find the log by ID and delete it
        $log = ClearanceLog::find($logId);
        if ($log) {
            $log->delete();
            return response()->json(['message' => 'Log deleted successfully.']);
        } else {
            return response()->json(['message' => 'Log not found.'], 404);
        }
    }
    public function dashboard()
    {
        $employeeData = Employee::selectRaw('MONTH(created_at) as month, COUNT(id) as total')
            ->groupBy('month')
            ->pluck('total', 'month');

        return view('Admin.dashboard', compact('employeeData'));
    }

    public function form()
    {


        $stores = Stores::all();
        $offices = Offices::all();
        return view('PreEmployment', compact('stores', 'offices'));
    }


    public function index(Request $request)
    {


        $user = Auth::user();

        // Get the agency IDs the user is assigned to
        $agencyIds = $user->viewable_agency_ids;

        $status = $request->get('status');

        $query = Employee::with('user', 'channelclient')->whereNot('status', 'Inactive')
            ->whereHas('channelclient', function ($query) {
                $query->whereNotNull('department_id');
            });

        if (!empty($agencyIds)) {

            $query->whereHas('channelclient.department.client.agency', function ($q) use ($agencyIds) {
                $q->whereIn('id', $agencyIds);
            });

            $assignIds = Assign::where('user_id', $user->id)
                ->whereIn('agency_id', $agencyIds)
                ->pluck('id');

            $restrictedDepartmentIds = AssignCompanyDepartment::whereIn('assigncompany_id', AssignCompany::whereIn('assign_id', $assignIds)
                ->pluck('id'))
                ->pluck('department_id')
                ->unique();

            if ($restrictedDepartmentIds->isNotEmpty()) {
                $query->whereHas('channelclient', function ($q) use ($restrictedDepartmentIds) {
                    $q->whereIn('department_id', $restrictedDepartmentIds);
                });
            }
        }

        if ($request->has('office_id') && $request->office_id) {
            $query->where('office_id', $request->office_id);
        }

        if ($request->has('store_id') && $request->store_id) {
            $query->where('store_id', $request->store_id);
        }
        if ($request->filled('pwd_filter')) {
            $pwdFilter = $request->pwd_filter;

            if ($pwdFilter === 'Not PWD') {
                $query->whereNull('pwd');
            } else {
                $query->where('pwd', $pwdFilter);
            }
        }
        if ($request->ajax()) {

            return DataTables::of($query)
                ->addColumn('action', function ($row) {
                    $actionBtn = '<div class="flex items-center justify-center gap-2">
                    <a href="' . url('admin/pre-profile/' . Crypt::encrypt($row->id)) . '" class="flex items-center justify-center w-8 h-8 text-white bg-green-600 rounded-md edit"><i class="text-xl bx bx-show"></i></a>
                      <button onclick="openDeleteModal(' . $row->id . ')" class="flex items-center justify-center w-8 h-8 text-white bg-green-600 rounded-md">
                            <i class="text-xl bx bx-trash-alt"></i>
                        </button>    </div>';
                    return $actionBtn;
                })
                ->addColumn('employee_name', function ($row) {
                    return $row->first_name . ' ' . ($row->middle_name ?? '') . ' ' . $row->last_name;
                })
                ->addColumn('action1', function ($row) {
                    $actionBtn = '<div class="flex items-center justify-center gap-2">
                    <a href="' . url('admin/pre-profile/' . Crypt::encrypt($row->id)) . '" class="flex items-center justify-center w-10 h-10 text-white bg-green-600 rounded-md edit"><i class="text-xl bx bx-show"></i></a>
                     </div>';
                    return $actionBtn;
                })

                ->addColumn('client', function ($row) {
                    // Find the channel client where the status is 1
                    $activeClient = $row->channelclient->where('status', '1')->first();
                    return $activeClient ? $activeClient->department->department_name : 'No Active Client';
                })
                ->addColumn('company', function ($row) {
                    // Find the channel client where the status is 1
                    $activeClient = $row->channelclient->where('status', '1')->first();
                    return $activeClient ? $activeClient->department->client->business_name : 'No Active Client';
                })
                ->addColumn('agency', function ($row) {
                    // Find the channel client where the status is 1
                    $activeClient = $row->channelclient->where('status', '1')->first();
                    return $activeClient ? $activeClient->department->client->agency->name : 'No Active Client';
                })
                ->addColumn('profile', function ($row) {
                    // Assuming the profile image URL is stored in $row->profile_image
                    $imageUrl = $row->profile ? asset($row->profile) : asset('/default/image.png'); // Replace with your default image path
                    return '<div class="flex items-center justify-center"><img src="' . $imageUrl . '" alt="Profile Image" style="width: 50px; height: 50px; border-radius: 50%;"></div>';
                })
                ->filter(function ($query) use ($request) {
                    if ($search = $request->get('search')['value']) {
                        $query->where(function ($q) use ($search) {
                            $q->where('first_name', 'like', "%{$search}%")
                                ->orWhere('middle_name', 'like', "%{$search}%")
                                ->orWhere('last_name', 'like', "%{$search}%")
                                ->orWhereHas(
                                    'channelclient.department',
                                    fn($d) =>
                                    $d->where('department_name', 'like', "%{$search}%")
                                )
                                ->orWhereHas(
                                    'channelclient.department.client',
                                    fn($c) =>
                                    $c->where('business_name', 'like', "%{$search}%")
                                )
                                ->orWhereHas(
                                    'channelclient.department.client.agency',
                                    fn($a) =>
                                    $a->where('name', 'like', "%{$search}%")
                                );
                        });
                    }
                })
                ->addColumn('status', function ($row) {
                    $status = '<div class="flex items-center justify-center">
                    <span class="w-3 h-3 bg-green-500 rounded-full"></span>
                    <span class="ml-2">Active</span>
                </div>';

                    return $status;
                })



                ->addColumn('bank_status', function ($row) {
                    if ($row->bank_number == null) {
                        $bank_status = 'For Application';
                    } else {
                        $bank_status = 'Submitted';
                    }

                    return $bank_status;
                })


                ->rawColumns(['action', 'action1', 'profile', 'status'])
                ->make(true);
        }
        $employees = Employee::with('user')->get();
        $offices = Offices::all();
        $stores = Stores::all();
        return view('Admin.Employee.index', compact('employees', 'stores', 'offices'));
    }










    public function clearance(Request $request)
    {
        $privileges = $request->get('privileges');

        $user = Auth::user();

        // Get the agency IDs the user is assigned to
        $agencyIds = $user->viewable_agency_ids;

        $status = $request->get('status');

        $query = Employee::with('user')
            ->whereHas('channelclient', function ($query) {
                $query->whereNotNull('department_id') // Ensure there is an associated department_id
                    ->where('created_at', '<', Carbon::now()->subDays(30)); // Exclude new employees (less than a month old)
            })
            ->whereDoesntHave('payrolls', function ($query) {
                $query->where('created_at', '>=', Carbon::now()->subDays(30)); // Exclude employees with payrolls in the last 30 days
            });

        if (!empty($agencyIds)) {
            $query->whereHas('channelclient.department.client.agency', function ($q) use ($agencyIds) {
                $q->whereIn('id', $agencyIds);
            });


            $assignIds = Assign::where('user_id', $user->id)
                ->whereIn('agency_id', $agencyIds)
                ->pluck('id');

            $restrictedDepartmentIds = AssignCompanyDepartment::whereIn('assigncompany_id', AssignCompany::whereIn('assign_id', $assignIds)
                ->pluck('id'))
                ->pluck('department_id')
                ->unique();

            if ($restrictedDepartmentIds->isNotEmpty()) {
                $query->whereHas('channelclient', function ($q) use ($restrictedDepartmentIds) {
                    $q->whereIn('department_id', $restrictedDepartmentIds);
                });
            }
        }



        if ($request->ajax()) {
            $data = $query->get();

            return DataTables::of($data)
                ->addColumn('action', function ($row) use ($privileges) {
                    $fullName = $row->last_name . ' ' . $row->middle_name . ' ' . $row->first_name;

                    // Initialize the $button variable to hold the HTML
                    $button = '<div class="flex items-center justify-center gap-2">';

                    $bank_status = $row->bank_status; // Get the bank status from the model
    

                    if ($bank_status === null) {
                        $bank_status = 'Apply to Bank';
                    }


                    if (in_array($bank_status, $privileges)) {

                        if (in_array('Add Bank Remarks ', $privileges)) {
                            if ($row->clearance_status != 'RELEASE' || in_array('Navigate Status Edit', $privileges)) {

                                $button .= '<button class="flex items-center justify-center w-10 h-10 text-white bg-blue-600 rounded-md edit-btn" onclick="openStatusModal(' . $row->id . ', \'' . addslashes($fullName) . '\')">
                                    <i class="bx bx-comment-add"></i>
                                </button>';
                            }
                        }

                        if (in_array('View Bank Reports', $privileges)) {

                            $button .= '<button class="flex items-center justify-center w-10 h-10 text-white bg-green-600 rounded-md view-btn" onclick="openDetailsModal(' . $row->id . ')">
                                <i class="bx bx-show"></i>
                            </button>';
                        }
                        $button .= ' <a href="' . url('admin/pre-profile/' . Crypt::encrypt($row->id)) . '" class="flex items-center justify-center w-10 h-10 text-white bg-green-600 rounded-md view-btn">
        <i class="text-xl bx  bx-user-circle"></i>
    </a>';
                    }
                    // Close the div and return the button HTML
                    $button .= '</div>';

                    return $button;
                })

                ->addColumn('action1', function ($row) {
                    $actionBtn = '<div class="flex items-center justify-center gap-2">
                    <a href="' . url('admin/pre-profile/' . Crypt::encrypt($row->id)) . '" class="flex items-center justify-center w-10 h-10 text-white bg-green-600 rounded-md edit"><i class="text-xl bx bx-show"></i></a>
                     </div>';
                    return $actionBtn;
                })

                ->addColumn('client', function ($row) {
                    // Find the channel client where the status is 1
                    $activeClient = $row->channelclient->where('status', '1')->first();
                    return $activeClient ? $activeClient->department->department_name : 'No Active Client';
                })
                ->addColumn('claims', function ($row) {
                    return $row->claim_type ? $row->claim_type : 'Not Claimed Yet';
                })
                ->addColumn('company', function ($row) {
                    // Find the channel client where the status is 1
                    $activeClient = $row->channelclient->where('status', '1')->first();
                    return $activeClient ? $activeClient->department->client->business_name : 'No Active Client';
                })
                ->addColumn('agency', function ($row) {
                    // Find the channel client where the status is 1
                    $activeClient = $row->channelclient->where('status', '1')->first();
                    return $activeClient ? $activeClient->department->client->agency->name : 'No Active Client';
                })
                ->addColumn('profile', function ($row) {
                    // Assuming the profile image URL is stored in $row->profile_image
                    $imageUrl = $row->profile ? asset($row->profile) : asset('/default/image.png'); // Replace with your default image path
                    return '<div class="flex items-center justify-center"><img src="' . $imageUrl . '" alt="Profile Image" style="width: 50px; height: 50px; border-radius: 50%;"></div>';
                })

                ->addColumn('status', function ($row) {
                    // Update the status field in the database to 'Inactive'
                    $row->update(['status' => 'Inactive']);

                    if ($row->clearance_status == null) {
                        $status = '<div class="flex items-center justify-center">
                        <span class="w-3 h-3 bg-red-500 rounded-full"></span>
                        <span class="ml-2">Pending</span>
                    </div>';
                    } elseif ($row->clearance_status == 'PENDING') {
                        $status = '<div class="flex items-center justify-center">
                                <span class="w-3 h-3 bg-green-500 rounded-full"></span>
                                <span class="ml-2">Pending</span>
                            </div>';
                    } else {
                        $status = '<div class="flex items-center justify-center">
                        <span class="w-3 h-3 bg-green-500 rounded-full"></span>
                        <span class="ml-2">Release</span>
                    </div>';
                    }


                    return $status;
                })




                ->addColumn('name', function ($row) {
                    return '<div class="max-w-xs overflow-hidden whitespace-nowrap text-ellipsis">' .
                        htmlspecialchars($row->first_name . ' ' . $row->middle_name . ' ' . $row->last_name) .
                        '</div>';
                })

                ->rawColumns(['action', 'action1', 'name', 'profile', 'status'])
                ->make(true);
        }
        $employees = Employee::with('user')->get();

        return view('Admin.Employee.clearance.index', compact('employees'));
    }


























    public function forapporval(Request $request)
    {
        if ($request->ajax()) {
            $query = Employee::with('user')
                ->where(function ($q) {
                    $q->whereDoesntHave('channelclient')
                        ->orWhereHas('channelclient', function ($sub) {
                            $sub->whereNull('department_id');
                        });
                });

            // Apply filters if present
            if ($request->filled('office_id')) {
                $query->where('office_id', $request->office_id);
            }

            if ($request->filled('store_id')) {
                $query->where('store_id', $request->store_id);
            }

            if ($request->has('pwd_filter')) {
                $pwdFilter = $request->pwd_filter;
                if ($pwdFilter === 'Not PWD') {
                    $query->where('pwd', 'Not PWD');
                } elseif ($pwdFilter === 'PWD') {
                    $query->where('pwd', 'PWD');
                }
            }

            $data = $query->get();

            return DataTables::of($data)
                ->addColumn('action', function ($row) {
                    $actionBtn = '<div class="flex items-center justify-center gap-2">
                        <a href="' . url('admin/pre-profile/' . Crypt::encrypt($row->id)) . '" class="flex items-center justify-center w-8 h-8 text-white bg-green-600 rounded-md edit"><i class="text-xl bx bx-show"></i></a>
                        <button onclick="openDeleteModal(' . $row->id . ')" class="flex items-center justify-center w-8 h-8 text-white bg-green-600 rounded-md">
                            <i class="text-xl bx bx-trash-alt"></i>
                        </button>
                    </div>';
                    return $actionBtn;
                })->addColumn('mrf', function ($row) {
                    $actionBtn = '<div class="flex items-center justify-center gap-2">
                        <a href="' . url('admin/pre-profile/' . Crypt::encrypt($row->id)) . '" class="flex items-center justify-center w-8 h-8 text-white bg-green-600 rounded-md edit"><i class="text-xl bx bx-show"></i></a>
                        
                    </div>';
                    return $actionBtn;
                })
                ->addColumn('status', function ($row) {
                    return $row->status == 1 ? "Walk-in Applicant" : "Online Applicant";
                })
                ->addColumn('profile', function ($row) {
                    $imageUrl = $row->profile ? asset($row->profile) : asset('/default/image.png');
                    return '<div class="flex items-center justify-center"><img src="' . $imageUrl . '" alt="Profile Image" style="width: 50px; height: 50px; border-radius: 50%;"></div>';
                })
                ->addColumn('name', function ($row) {
                    return '<div class="max-w-xs overflow-hidden whitespace-nowrap text-ellipsis">' .
                        htmlspecialchars($row->first_name . ' ' . $row->middle_name . ' ' . $row->last_name) .
                        '</div>';
                })
                ->rawColumns(['action', 'name', 'mrf', 'profile'])
                ->make(true);
        }

        // Non-AJAX case
        $employees = Employee::with('user')->get();
        $offices = Offices::all();
        $stores = Stores::all();

        return view('Admin.Employee.approval', compact('employees', 'offices', 'stores'));
    }


    public function employeebank(Request $request)
    {

        $privileges = $request->get('privileges');

        $user = Auth::user();

        // Get the agency IDs the user is assigned to
        $agencyIds = $user->viewable_agency_ids;


        $query = EmployeeClientChannel::with('employee.user', 'employee', 'department.client.agency')
            ->where(function ($q) {
                $q->whereNull('bank_status')->orWhereNotNull('bank_status');
            });
        if (!empty($agencyIds)) {

            $query->whereHas('department.client.agency', function ($q) use ($agencyIds) {
                $q->whereIn('id', $agencyIds);
            });

            $assignIds = Assign::where('user_id', $user->id)
                ->whereIn('agency_id', $agencyIds)
                ->pluck('id');

            // Get the company IDs restricted via assignCompanies
            $restrictedCompanyIds = AssignCompany::whereIn('assign_id', $assignIds)
                ->pluck('id');

            $restrictedDepartmentIds = AssignCompanyDepartment::whereIn('assigncompany_id', $restrictedCompanyIds)
                ->pluck('department_id')
                ->unique();


            // Apply company restriction only if there are any
            if ($restrictedDepartmentIds->isNotEmpty()) {
                $query->whereIn('department_id', $restrictedDepartmentIds);
            }
        }


        $query->where(function ($q) use ($privileges) {

            if (in_array('Apply to Bank', $privileges)) {
                $q->orWhereNull('bank_status')->orWhere('bank_status', 'Apply to Bank')->orWhere('bank_status', 'Pending with Discrepancy')->orWhere('bank_status', 'Available for Pickup')->orWhere('bank_status', 'With Certification')->orWhere('bank_status', 'Forwarded to Accounting');
            }
            if (in_array('Pending with Discrepancy', $privileges)) {
                $q->orWhere('bank_status', 'Pending with Discrepancy')->orWhere('bank_status', 'Available for Pickup')->orWhere('bank_status', 'With Certification')->orWhere('bank_status', 'Forwarded to Accounting');
            }
            if (in_array('Available for Pickup', $privileges)) {
                $q->orWhere('bank_status', 'Available for Pickup')->orWhere('bank_status', 'With Certification')->orWhere('bank_status', 'Forwarded to Accounting');
            }
            if (in_array('With Certification', $privileges)) {
                $q->orWhere('bank_status', 'With Certification')->orWhere('bank_status', 'Forwarded to Accounting');
            }
            if (in_array('Forwarded to Accounting', $privileges)) {
                $q->orWhere('bank_status', 'Forwarded to Accounting');
            }
        });




        if ($request->ajax()) {
            if ($request->filled('bank_status')) {
                if ($request->bank_status === 'for_application') {
                    $query->whereNull('bank_status');
                } else {
                    $query->where('bank_status', $request->bank_status);
                }
            }
            $data = $query->get();

            return DataTables::of($data)
                ->addColumn('status', function ($row) {
                    if ($row->bank_status == null) {
                        $status = 'For Application';
                    } else {
                        $status = $row->bank_status;
                    }
                    return $status;
                })
                ->addColumn('profile', function ($row) {
                    // Assuming the profile image URL is stored in $row->profile_image
                    $imageUrl = $row->employee->profile ? asset($row->employee->profile) : asset('/default/image.png'); // Replace with your default image path
                    return '<div class="flex items-center justify-center"><img src="' . $imageUrl . '" alt="Profile Image" style="width: 50px; height: 50px; border-radius: 50%;"></div>';
                })
                ->addColumn('client', function ($row) {
                    return $row->department ? $row->department->department_name : 'No Active Client';
                })

                ->addColumn('company', function ($row) {

                    return $row->department->client ? $row->department->client->business_name : 'No Active Client';
                })
                ->addColumn('agency', function ($row) {

                    return $row->department->client->agency ? $row->department->client->agency->name : 'No Active Client';
                })


                ->addColumn('name', function ($row) {
                    return '<div class="max-w-xs overflow-hidden whitespace-nowrap text-ellipsis">' .
                        htmlspecialchars($row->employee->first_name . ' ' . $row->employee->middle_name . ' ' . $row->employee->last_name) .
                        '</div>';
                })
                ->addColumn('action', function ($row) use ($privileges) {
                    $fullName = $row->employee->last_name . ', ' . $row->employee->first_name . ' ' . $row->employee->middle_name;

                    $button = '<div class="flex items-center justify-center gap-2">';

                    $bank_status = $row->bank_status;


                    if ($bank_status === null) {
                        $bank_status = 'Apply to Bank';
                    }


                    if (in_array($bank_status, $privileges)) {

                        if (in_array('Add Bank Remarks ', $privileges)) {
                            if ($row->bank_status != 'Forwarded to Accounting' || in_array('Navigate Status Edit', $privileges)) {

                                $button .= '<button class="flex items-center justify-center w-8 h-8 text-white bg-blue-600 rounded-md edit-btn" onclick="openStatusModal(' . $row->id . ', \'' . addslashes($fullName) . '\')">
                                        <i class="bx bx-comment-add"></i>
                                    </button>';
                            }
                        }

                        if (in_array('View Bank Reports', $privileges)) {

                            $button .= '<button class="flex items-center justify-center w-8 h-8 text-white bg-green-600 rounded-md view-btn" onclick="openDetailsModal(' . $row->id . ')">
                                    <i class="bx bx-show"></i>
                                </button>';
                        }
                    }

                    $button .= '</div>';

                    return $button;
                })



                ->rawColumns(['action', 'name', 'profile'])
                ->make(true);
        }

        $banks = BankProfile::all();
        $employees = Employee::with('user')->get();
        return view('Admin.Employee.bank.index', compact('employees', 'banks'));
    }
    public function getLogs($employeeId)
    {

        $logs = BankLog::where('assignemployee_id', $employeeId)
            ->join('users', 'bank_logs.user_id', '=', 'users.id') // Join with the User model
            ->select('bank_logs.*', 'users.name as user_name') // Select logs data along with the user name
            ->get();


        return response()->json($logs);
    }
    public function clearanceLogs($employeeId)
    {
        $logs = ClearanceLog::where('employee_id', $employeeId)
            ->join('users', 'clearance_logs.user_id', '=', 'users.id') // Join with the User model
            ->select('clearance_logs.*', 'users.name as user_name') // Select logs data along with the user name
            ->get();

        return response()->json($logs);
    }


    public function employmenthistory(Request $request, $id)
    {
        if ($request->ajax()) {
            $data = EmployeeClientChannel::with('department.client.agency', 'employee')
                ->where('employee_id', $id)
                ->orderByRaw('status = 1 DESC') // Records with status = 1 will appear first
                ->get();



            return DataTables::of($data)


                ->addColumn('employeestatus', function ($row) {

                    if ($row->status == 1) {
                        return 'Active';
                    } else {
                        return 'Inactive';
                    }

                })
                ->addColumn('agency_name', function ($row) {
                    return $row->department->client->agency->name;
                })
                ->addColumn('company_name', function ($row) {
                    return $row->department->client->business_name;
                })
                ->addColumn('client_name', function ($row) {
                    return $row->department->department_name;
                })



                ->addColumn('action', function ($row) {
                    return '<div class="flex items-center justify-center gap-2">
                        <button class="flex items-center justify-center w-10 h-10 text-white bg-blue-600 rounded-md edit-btn" data-id="' . $row->id . '">
                            <i class="bx bx-edit-alt"></i>
                        </button>
                        <button class="flex items-center justify-center w-10 h-10 text-white bg-red-600 rounded-md delete-btn" data-id="' . $row->id . '">
                            <i class="text-xl bx bx-trash-alt"></i>
                        </button>
                    </div>';
                })

                ->make(true);
        }
    }
    public function updateDtr(Request $request)
    {
        $request->validate([
            'id' => 'required|exists:assignemployeee,id',
            'dtr_id' => 'nullable|string|max:255',
            'bankprofile_id' => 'nullable|exists:bank_profiles,id',
            'bankaccount' => 'nullable|string|max:255',

        ]);

        $record = EmployeeClientChannel::findOrFail($request->id);

        if ($request->has('dtr_id')) {
            $record->dtr_id = $request->dtr_id;
        }

        if ($request->has('bankprofile_id')) {
            $record->bankprofile_id = $request->bankprofile_id;
        }
        if ($request->has('bankaccount')) {
            $record->bankaccount = $request->bankaccount;
        }



        $record->save();

        return response()->json(['message' => 'Employee data updated successfully!']);
    }



    public function showemployeedetails1()
    {
        $userId = auth()->id();

        // Fetch the employee record associated with the authenticated user
        $trx = TrxCode::get();
        $bankProfiles = BankProfile::all(['id', 'name']);
        $loggedInEmployee = Employee::where('user_id', $userId)->first();
        $employee1 = EmployeeClientChannel::with('department.client', 'employee.user')
            ->where('employee_id', $loggedInEmployee->id)->where('status', '1')
            ->get();
        $clients = Client::all();
        $employee = Employee::with('user')->find($loggedInEmployee->id);

        $stores = Stores::all();
        $offices = Offices::all();
        $shift = Shift::all();
        $data = leave::with('employee')->where('employee_id', $loggedInEmployee->id)->get();

        $brackets = CustomBraket::all();
        $defaultrate = DefaultRate::all();

        $schedules = WorkSchedule::with('shift')
            ->where('employee_id', $loggedInEmployee->id)
            ->get();

        $events = $schedules->map(function ($sched) {
            return [
                'title' => $sched->shift->shift_name,
                'start' => $sched->start_date,
                'end' => date('Y-m-d', strtotime($sched->end_date . ' +1 day')), // FullCalendar exclusive end
                'extendedProps' => [
                    'shift_start' => $sched->shift->shift_start,
                    'shift_end' => $sched->shift->shift_end,
                ],
            ];
        });


        return view('Admin.Employee.employeedetails', compact('events', 'schedules', 'employee', 'brackets', 'shift', 'bankProfiles', 'stores', 'offices', 'clients', 'employee1', 'data', 'trx', 'defaultrate'));
    }





    public function showemployeedetails($id)
    {
        try {
            // Decrypt the ID
            $decryptedId = Crypt::decrypt($id);

            // Proceed with your logic using the decrypted ID
            $trx = TrxCode::get();
            $bankProfiles = BankProfile::all(['id', 'name']);
            $employee1 = EmployeeClientChannel::with('department.client', 'employee.user')
                ->where('employee_id', $decryptedId)->where('status', '1')
                ->get();
            $clients = Client::all();
            $employee = Employee::with('user')->find($decryptedId);
            $data = leave::with('employee')->where('employee_id', $decryptedId)->get();

            $stores = Stores::all();
            $offices = Offices::all();
            $shift = Shift::all();
            $brackets = CustomBraket::all();
            $defaultrate = DefaultRate::all();



            $schedules = WorkSchedule::with('shift')
                ->where('employee_id', $decryptedId)
                ->get();

            $events = $schedules->map(function ($sched) {
                return [
                    'title' => $sched->shift->shift_name,
                    'start' => \Carbon\Carbon::parse($sched->start_date)->format('Y-m-d'),
                    'end' => \Carbon\Carbon::parse($sched->end_date)->addDay()->format('Y-m-d'),
                    'extendedProps' => [
                        'shift_start' => $sched->shift->shift_start,
                        'shift_end' => $sched->shift->shift_end,
                    ],
                ];
            });




            return view('Admin.Employee.employeedetails', compact('employee', 'schedules', 'events', 'brackets', 'shift', 'bankProfiles', 'clients', 'stores', 'offices', 'employee1', 'data', 'trx', 'defaultrate'));

        } catch (\Illuminate\Contracts\Encryption\DecryptException $e) {
            // Handle the case where decryption fails (maybe tampered URL)
            abort(404, 'Invalid or tampered employee ID');
        }
    }


    public function create()
    {
        $clients = Client::all();
        $department = Department::all();
        $stores = Stores::all();
        $offices = Offices::all();
        return view('Admin.Employee.create', compact('clients', 'department', 'stores', 'offices'));
    }

    // Store a newly created employee in the database
    public function store(Request $request)
    {
        // Validate the request input
        $validated = $request->validate([
            'first_name' => 'nullable|string|max:255',
            'position_applied' => 'nullable|string|max:255',

            'desired_working_area' => 'nullable|string|max:255',
            'middle_name' => 'nullable|string|max:255',
            'last_name' => 'required|string|max:255',
            'email' => 'required|string|email|max:255|unique:users',
            'present_address' => 'nullable|string|max:255',
            'provincial_address' => 'nullable|string|max:255',
            'mobile_number' => 'nullable|string|max:20',
            'alternative_number' => 'nullable|string|max:20',
            'date_of_birth' => 'nullable|date',
            'age' => 'nullable|integer',
            'place_of_birth' => 'nullable|string|max:255',
            'civil_status' => 'nullable|string|max:20',
            'nationality' => 'nullable|string|max:50',
            'religion' => 'nullable|string|max:50',
            'height' => 'nullable|string|max:10',
            'weight' => 'nullable|string|max:10',
            'spouse_name' => 'nullable|string|max:255',
            'spouse_occupation' => 'nullable|string|max:255',
            'mother_maiden_name' => 'nullable|string|max:255',
            'mother_occupation' => 'nullable|string|max:255',
            'father_name' => 'nullable|string|max:255',
            'father_occupation' => 'nullable|string|max:255',
            'sss_no' => 'nullable|string|max:20',
            'tin_no' => 'nullable|string|max:20',
            'pagibig_no' => 'nullable|string|max:20',
            'dependents' => 'nullable|integer',
            'philhealth_no' => 'nullable|string|max:20',
            'blood_type' => 'nullable|string|max:10',
            'education_school' => 'nullable|string|max:255',
            'education_course_level' => 'nullable|string|max:255',
            'education_year' => 'nullable|string|max:4',
            'relevant_qualifications' => 'nullable|string|max:500',

            'employment_start_date' => 'nullable|date',
            'employment_end_date' => 'nullable|date',
            'position' => 'nullable|string|max:255',
            'salary' => 'nullable|numeric',
            'emergency_contact_name' => 'nullable|string|max:255',
            'emergency_contact_number' => 'nullable|string|max:20',
            'emergency_contact_address' => 'nullable|string|max:255',
            'emergency_contact_occupation' => 'nullable|string|max:255',

            'emergency_contact_company' => 'nullable|string|max:255',
            'emergency_contact_business_tel' => 'nullable|string|max:20',
            'department_id' => 'nullable|string|max:20',
            'date_hired' => 'nullable|date',
            'store_id' => 'nullable|string|max:255',
            'office_id' => 'nullable|string|max:255',
            'pwd' => 'nullable|string|max:255',
            'pwd_file' => 'nullable|string|max:255',
            'sex' => 'nullable|string|max:255',

        ]);


        $user = User::create([
            'name' => $validated['first_name'] . $validated['middle_name'] . $validated['last_name'],
            'email' => $validated['email'],
            'password' => Hash::make('123'),

            'role_id' => 9,
        ]);

        $picturePath = null;
        if ($request->hasFile('profile')) {
            $file = $request->file('profile');
            $file_name = time() . '.' . $file->getClientOriginalExtension();
            $destination = public_path('uploads');
            $file->move($destination, $file_name);
            $picturePath = 'uploads/' . $file_name;
        }
        $filePath = null;
        if ($request->hasFile('file')) {
            $file1 = $request->file('file');
            $file_name1 = time() . '.' . $file1->getClientOriginalExtension();
            $destination1 = public_path(path: 'uploads');
            $file1->move($destination1, $file_name1);
            $filePath = 'uploads/' . $file_name1;
        }


        $status = $request->input('status');
        $employee = Employee::create([
            'user_id' => $user->id,
            'store_id' => $validated['store_id'],
            'office_id' => $validated['office_id'],
            'first_name' => $validated['first_name'],
            'middle_name' => $validated['middle_name'],

            'position_applied' => $validated['position_applied'],
            'desired_working_area' => $validated['desired_working_area'],
            'last_name' => $validated['last_name'],
            'present_address' => $validated['present_address'],
            'provincial_address' => $validated['provincial_address'],
            'mobile_number' => $validated['mobile_number'],
            'alternative_number' => $validated['alternative_number'],
            'date_of_birth' => $validated['date_of_birth'],
            'age' => $validated['age'],
            'place_of_birth' => $validated['place_of_birth'],
            'civil_status' => $validated['civil_status'] ?? null,
            'nationality' => $validated['nationality'],
            'religion' => $validated['religion'],
            'height' => $validated['height'],
            'weight' => $validated['weight'],
            'spouse_name' => $validated['spouse_name'],
            'spouse_occupation' => $validated['spouse_occupation'],
            'mother_maiden_name' => $validated['mother_maiden_name'],
            'mother_occupation' => $validated['mother_occupation'],
            'father_name' => $validated['father_name'],
            'father_occupation' => $validated['father_occupation'],
            'sss_no' => $validated['sss_no'],
            'tin_no' => $validated['tin_no'],
            'pagibig_no' => $validated['pagibig_no'],
            'dependents' => $validated['dependents'],
            'philhealth_no' => $validated['philhealth_no'],
            'blood_type' => $validated['blood_type'],
            'education_school' => $validated['education_school'],
            'education_course_level' => $validated['education_course_level'],
            'education_year' => $validated['education_year'],
            'relevant_qualifications' => $validated['relevant_qualifications'],
            'emergency_contact_name' => $validated['emergency_contact_name'],
            'emergency_contact_number' => $validated['emergency_contact_number'],
            'emergency_contact_address' => $validated['emergency_contact_address'],
            'emergency_contact_occupation' => $validated['emergency_contact_occupation'],

            'emergency_contact_company' => $validated['emergency_contact_company'],
            'emergency_contact_business_tel' => $validated['emergency_contact_business_tel'],
            'status' => $status,
            'pwd' => $validated['pwd'],
            'sex' => $validated['sex'],

        ]);
        $employee->profile = $picturePath;
        $employee->pwd_file = $filePath;
        $employee->save();


        return redirect()->route('pre.profile', ['id' => Crypt::encrypt($employee->id)])
            ->with('success', 'Employee added successfully!');
    }

    public function outautstore(Request $request)
    {
        // Validate the request input
        $validated = $request->validate([
            'first_name' => 'required|string|max:255',
            'position_applied' => 'nullable|string|max:255',
            'desired_working_area' => 'nullable|string|max:255',
            'middle_name' => 'nullable|string|max:255',
            'last_name' => 'required|string|max:255',
            'email' => 'required|string|email|max:255|unique:users',
            'present_address' => 'nullable|string|max:255',
            'provincial_address' => 'nullable|string|max:255',
            'mobile_number' => 'nullable|string|max:20',
            'alternative_number' => 'nullable|string|max:20',
            'date_of_birth' => 'nullable|date',
            'age' => 'nullable|integer',
            'place_of_birth' => 'nullable|string|max:255',
            'civil_status' => 'nullable|string|max:20',
            'nationality' => 'nullable|string|max:50',
            'religion' => 'nullable|string|max:50',
            'height' => 'nullable|string|max:10',
            'weight' => 'nullable|string|max:10',
            'spouse_name' => 'nullable|string|max:255',
            'spouse_occupation' => 'nullable|string|max:255',
            'mother_maiden_name' => 'nullable|string|max:255',
            'mother_occupation' => 'nullable|string|max:255',
            'father_name' => 'nullable|string|max:255',
            'father_occupation' => 'nullable|string|max:255',
            'sss_no' => 'nullable|string|max:20',
            'tin_no' => 'nullable|string|max:20',
            'pagibig_no' => 'nullable|string|max:20',
            'dependents' => 'nullable|integer',
            'philhealth_no' => 'nullable|string|max:20',
            'blood_type' => 'nullable|string|max:10',
            'education_school' => 'nullable|string|max:255',
            'education_course_level' => 'nullable|string|max:255',
            'education_year' => 'nullable|string|max:4',
            'relevant_qualifications' => 'nullable|string|max:500',
            'emergency_contact_name' => 'nullable|string|max:255',
            'emergency_contact_number' => 'nullable|string|max:20',
            'emergency_contact_address' => 'nullable|string|max:255',
            'emergency_contact_occupation' => 'nullable|string|max:255',
            'emergency_contact_relation' => 'nullable|string|max:255',
            'emergency_contact_company' => 'nullable|string|max:255',
            'emergency_contact_business_tel' => 'nullable|string|max:20',
            'department_id' => 'nullable|string|max:20',
            'date_hired' => 'nullable|date',
            'store_id' => 'nullable|string|max:255',
            'office_id' => 'nullable|string|max:255',
            'pwd' => 'nullable|string|max:255',
            'pwd_file' => 'nullable|string|max:255',
            'sex' => 'nullable|string|max:255',
            'Name' => 'nullable|string|max:255',

        ]);
        $exists = Employee::where('first_name', $validated['first_name'])
            ->where('middle_name', $validated['middle_name'])
            ->where('last_name', $validated['last_name'])
            ->exists();

        if ($exists) {
            return redirect()->back()
                ->withInput()
                ->withErrors(['first_name' => 'An employee with the same name already exists.']);
        }

        $user = User::create([
            'name' => $validated['first_name'] . $validated['middle_name'] . $validated['last_name'],
            'email' => $validated['email'],
            'password' => Hash::make('123'), // Change 123 to a string by using quotes

            'role_id' => 9, // You can assign a role here or leave it null
        ]);

        $picturePath = null;
        if ($request->hasFile('profile')) {

            $file = $request->file('profile');
            $file_name = 'profiles/' . time() . '.' . $file->getClientOriginalExtension();
            Storage::disk('spaces')->put($file_name, file_get_contents($file), 'public');

            $picturePath = $file_name;
        }

        $filePath = null;
        if ($request->hasFile('file')) {


            $file1 = $request->file('file');
            $file_name1 = 'documents/' . time() . '.' . $file1->getClientOriginalExtension();
            Storage::disk('spaces')->put($file_name1, file_get_contents($file1), 'public');

            $filePath = $file_name1;
        }

        $employee = Employee::create([
            'user_id' => $user->id,
            'store_id' => $validated['store_id'] ?? null,
            'office_id' => $validated['office_id'] ?? null,
            'first_name' => $validated['first_name'],
            'middle_name' => $validated['middle_name'],
            'position_applied' => $validated['first_name'],
            'desired_working_area' => $validated['middle_name'],
            'last_name' => $validated['last_name'],
            'present_address' => $validated['present_address'],
            'provincial_address' => $validated['provincial_address'],
            'mobile_number' => $validated['mobile_number'],
            'alternative_number' => $validated['alternative_number'],
            'date_of_birth' => $validated['date_of_birth'],
            'age' => $validated['age'],
            'place_of_birth' => $validated['place_of_birth'],
            'civil_status' => $validated['civil_status'] ?? null,
            'nationality' => $validated['nationality'],
            'religion' => $validated['religion'],
            'height' => $validated['height'],
            'weight' => $validated['weight'],
            'spouse_name' => $validated['spouse_name'],
            'spouse_occupation' => $validated['spouse_occupation'],
            'mother_maiden_name' => $validated['mother_maiden_name'],
            'mother_occupation' => $validated['mother_occupation'],
            'father_name' => $validated['father_name'],
            'father_occupation' => $validated['father_occupation'],
            'sss_no' => $validated['sss_no'],
            'tin_no' => $validated['tin_no'],
            'pagibig_no' => $validated['pagibig_no'],
            'dependents' => $validated['dependents'],
            'philhealth_no' => $validated['philhealth_no'],
            'blood_type' => $validated['blood_type'],
            'education_school' => $validated['education_school'],
            'education_course_level' => $validated['education_course_level'],
            'education_year' => $validated['education_year'],
            'relevant_qualifications' => $validated['relevant_qualifications'],

            'emergency_contact_name' => $validated['emergency_contact_name'],
            'emergency_contact_number' => $validated['emergency_contact_number'],
            'emergency_contact_address' => $validated['emergency_contact_address'],
            'emergency_contact_occupation' => $validated['emergency_contact_occupation'],
            'emergency_contact_relation' => $validated['emergency_contact_relation'],
            'emergency_contact_company' => $validated['emergency_contact_company'],
            'emergency_contact_business_tel' => $validated['emergency_contact_business_tel'],
            'status' => 3,
            'pwd' => $validated['pwd'],
            'sex' => $validated['sex'],


        ]);
        $employee->profile = $picturePath;
        $employee->pwd_file = $filePath;
        $employee->save();

        if ($request->hasFile('resume')) {


            $file = $request->file('resume');
            $file_name = 'resumes/' . time() . '.' . $file->getClientOriginalExtension(); // Folder inside Space
            Storage::disk('spaces')->put($file_name, file_get_contents($file), 'public');



            EmployeeFile::create([
                'employee_id' => $employee->id,
                'Name' => $validated['Name'],
                'file' => $file_name,
            ]);
        }

        return redirect()->back()->with('success', 'Employee added successfully!');
    }


    // Display a specific employee
    public function show(Employee $employee)
    {
        return view('employees.show', compact('employee'));
    }

    // Show the form for editing an existing employee
    public function statusupdate(Request $request, $id)
    {
        $employee = Employee::find($id);
        $employee->status = $request->input('status');
        $employee->save();


        return redirect()->back()->with('success', '' . $employee->last_name . '' . 'Employee Status updated successfully!');
    }

    // Update an employee in the database
    public function update(Request $request, $employeeId)
    {
        // Find the employee record by ID
        $employee = Employee::findOrFail($employeeId);

        // Find the associated user record
        $user = $employee->user; // Assuming you have a relationship defined in Employee model

        // Validate the request input
        $validated = $request->validate([
            'dtr_id' => 'nullable|string|max:255|unique:employees,dtr_id',


            'first_name' => 'nullable|string|max:255',
            'position_applied' => 'nullable|string|max:255',
            // 'bank_number' => 'nullable|string|max:255',
            'desired_working_area' => 'nullable|string|max:255',
            'middle_name' => 'nullable|string|max:255',
            'last_name' => 'nullable|string|max:255',
            'email' => 'nullable|string|email|max:255|unique:users,email,' . $user->id, // Exclude current user's email from uniqueness check
            'present_address' => 'nullable|string|max:255',
            'provincial_address' => 'nullable|string|max:255',
            'mobile_number' => 'nullable|string|max:20',
            'alternative_number' => 'nullable|string|max:20',
            'date_of_birth' => 'nullable|date',
            'age' => 'nullable|integer',
            'place_of_birth' => 'nullable|string|max:255',
            'civil_status.*' => 'nullable|string|max:20',
            'civil_status' => 'nullable|string|max:20',
            'nationality' => 'nullable|string|max:50',
            'religion' => 'nullable|string|max:50',
            'height' => 'nullable|string|max:10',
            'weight' => 'nullable|string|max:10',
            'spouse_name' => 'nullable|string|max:255',
            'spouse_occupation' => 'nullable|string|max:255',
            'mother_maiden_name' => 'nullable|string|max:255',
            'mother_occupation' => 'nullable|string|max:255',
            'father_name' => 'nullable|string|max:255',
            'father_occupation' => 'nullable|string|max:255',
            'sss_no' => 'nullable|string|max:20',
            'tin_no' => 'nullable|string|max:20',
            'pagibig_no' => 'nullable|string|max:20',
            'dependents' => 'nullable|integer',
            'philhealth_no' => 'nullable|string|max:20',
            'blood_type' => 'nullable|string|max:10',
            'education_school' => 'nullable|string|max:255',
            'education_course_level' => 'nullable|string|max:255',
            'education_year' => 'nullable|string|max:4',
            'relevant_qualifications' => 'nullable|string|max:500',

            'employment_start_date' => 'nullable|date',
            'employment_end_date' => 'nullable|date',
            'position' => 'nullable|string|max:255',
            'salary' => 'nullable|numeric',
            'emergency_contact_name' => 'nullable|string|max:255',
            'emergency_contact_number' => 'nullable|string|max:20',
            'emergency_contact_address' => 'nullable|string|max:255',
            'emergency_contact_occupation' => 'nullable|string|max:255',
            'emergency_contact_relation' => 'nullable|string|max:255',
            'emergency_contact_company' => 'nullable|string|max:255',
            'emergency_contact_business_tel' => 'nullable|string|max:20',
            'status' => 'nullable|string',
            'profile' => 'nullable|image|mimes:jpeg,png,jpg,gif|max:5048', // Validate the image
            'department_id' => 'nullable|string|max:20',
            'date_hired' => 'nullable|date',

        ]);

        // Update the employee's details
        $employee->update([

            'first_name' => $validated['first_name'],
            'middle_name' => $validated['middle_name'],
            // 'bank_number' => $validated['bank_number'],
            'position_applied' => $validated['position_applied'],
            'desired_working_area' => $validated['desired_working_area'],
            'last_name' => $validated['last_name'],
            'present_address' => $validated['present_address'],
            'provincial_address' => $validated['provincial_address'],
            'mobile_number' => $validated['mobile_number'],
            'alternative_number' => $validated['alternative_number'],
            'date_of_birth' => $validated['date_of_birth'],
            'age' => $validated['age'],
            'place_of_birth' => $validated['place_of_birth'],
            'civil_status' => $validated['civil_status'] ?? null,

            'nationality' => $validated['nationality'],
            'religion' => $validated['religion'],
            'height' => $validated['height'],
            'weight' => $validated['weight'],
            'spouse_name' => $validated['spouse_name'],
            'spouse_occupation' => $validated['spouse_occupation'],
            'mother_maiden_name' => $validated['mother_maiden_name'],
            'mother_occupation' => $validated['mother_occupation'],
            'father_name' => $validated['father_name'],
            'father_occupation' => $validated['father_occupation'],
            'sss_no' => $validated['sss_no'],
            'tin_no' => $validated['tin_no'],
            'pagibig_no' => $validated['pagibig_no'],
            'dependents' => $validated['dependents'],
            'philhealth_no' => $validated['philhealth_no'],
            'blood_type' => $validated['blood_type'],
            'education_school' => $validated['education_school'],
            'education_course_level' => $validated['education_course_level'],
            'education_year' => $validated['education_year'],
            'relevant_qualifications' => $validated['relevant_qualifications'],
            'emergency_contact_name' => $validated['emergency_contact_name'],
            'emergency_contact_number' => $validated['emergency_contact_number'],
            'emergency_contact_address' => $validated['emergency_contact_address'],
            'emergency_contact_occupation' => $validated['emergency_contact_occupation'],
            'emergency_contact_relation' => $validated['emergency_contact_relation'],
            'emergency_contact_company' => $validated['emergency_contact_company'],
            'emergency_contact_business_tel' => $validated['emergency_contact_business_tel'],
            'status' => $validated['status'],

        ]);

        // Check if the request has a new profile image
        // if ($request->hasFile('profile')) {
        //     // Delete the old image if it exists
        //     if ($employee->profile && file_exists(public_path('uploads/' . $employee->profile))) {
        //         @unlink(public_path('uploads/' . $employee->profile)); // Suppress errors with @ if file doesn't exist
        //     }

        //     // Upload the new profile image and update in one step
        //     $file = $request->file('profile');
        //     $file_name = time() . '.' . $file->getClientOriginalExtension();
        //     $destination = public_path('uploads');
        //     $file->move($destination, $file_name);
        //     $picturePath = 'uploads/' . $file_name;
        //     $employee->profile = $picturePath;
        //     $employee->update();
        // }


        if ($request->hasFile('profile')) {
            // Delete the old image from Spaces if it exists
            if ($employee->profile) {
                Storage::disk('spaces')->delete($employee->profile);
            }

            // Upload the new profile image to Spaces
            $file = $request->file('profile');
            $file_name = 'profiles/' . time() . '.' . $file->getClientOriginalExtension(); // Folder inside Space
            Storage::disk('spaces')->put($file_name, file_get_contents($file), 'public');

            // Save the path in the database (relative path)
            $employee->profile = $file_name;
            $employee->update();
        }



        // Update the user's email if it has changed
        if ($request->input('email') !== $user->email) {
            $user->update(['email' => $validated['email']]);
        }
        if ($request->has('department_id')) {
            // First, update the status of existing records where employee_id matches and status is 1
            EmployeeClientChannel::where('employee_id', $employee->id)
                ->where('status', '1') // Assuming you want to change only the records with status 1
                ->update(['status' => '2']); // Change the status to 2

            // Now, create a new record for the employee with status 1
            EmployeeClientChannel::create([
                'employee_id' => $employee->id,
                'department_id' => $validated['department_id'],
                'date_hired' => $validated['date_hired'], // Assuming you have this input
                'status' => '1', // New assignment gets status 1
                'employment_start_date' => $validated['employment_start_date'],
                'employment_end_date' => $validated['employment_end_date'],
                'position' => $validated['position'],
                'salary' => $validated['salary'],
            ]);
        }


        // Redirect with success message
        return redirect()->back()->with('success', 'Employee updated successfully!');
    }


    public function updatebanknumber(Request $request, $employee_id)
    {
        $validated = $request->validate([
            'status' => 'required|string|max:255',
            'bank_name' => 'nullable',
            'bank_number' => 'nullable|string|max:255',
            'date' => 'required|date',
            'remarks' => 'nullable|string|max:300',
            'file' => 'nullable|file|mimes:pdf,jpg,png,doc,docx,jpeg,png,jpg,gif|max:2048', // Updated to 'file'
        ]);

        $employee = EmployeeClientChannel::findOrFail($employee_id);

        // Update employee fields
        $employee->bank_status = $validated['status'];
        if ($request->has('bank_name')) {
            $employee->bankprofile_id = $validated['bank_name'];
        }
        if ($request->has('bank_number')) {
            $employee->bankaccount = $validated['bank_number'];
        }
        $employee->save();

        $user_id = Auth::user()->id;

        // Handle file upload (if exists)
        $filePath = null;
        if ($request->hasFile('file')) {  // Make sure the file field is named 'file'
            $file = $request->file('file');
            $file_name = time() . '.' . $file->getClientOriginalExtension();
            $destination = public_path('uploads');
            $file->move($destination, $file_name);
            $filePath = 'uploads/' . $file_name;
        }

        // Log the update in BankLog
        BankLog::create([
            'assignemployee_id' => $employee_id,
            'user_id' => $user_id,
            'date' => $validated['date'],
            'action' => $validated['status'],
            'remarks' => $validated['remarks'] ?? null,
            'file' => $filePath,
        ]);

        return response()->json(['message' => 'Employee updated successfully.']);
    }

    public function clearance_store(Request $request, $employee_id)
    {
        $validated = $request->validate([
            'status' => 'nullable|string|max:255',
            'status_claim' => 'nullable|string|max:255',
            'cheque' => 'nullable|string|max:255',
            'amount' => 'nullable|string|max:255',
            'claim_type' => 'nullable|string|max:255',
            'date' => 'required|date',
            'remarks' => 'nullable|string|max:300',
            'file' => 'nullable|file|mimes:pdf,jpg,png,doc,docx|max:2048', // Example file validation
        ]);

        $employee = Employee::findOrFail($employee_id);

        if ($request->filled('status_claim')) {
            $employee->clearance_status = $validated['status_claim'];
        }

        if ($request->filled('claim_type')) {
            $employee->claim_type = $validated['claim_type'];
        }

        $employee->save();

        $user_id = Auth::user()->id;

        ClearanceLog::create([
            'employee_id' => $employee_id,
            'user_id' => $user_id,
            'date' => $validated['date'],
            'action' => $validated['status'],
            'remarks' => $validated['remarks'] ?? null,
            'cheque' => $validated['cheque'] ?? null,
            'amount' => $validated['amount'] ?? null,

        ]);

        return response()->json(['message' => 'Employee updated successfully.']);
    }

    // Remove an employee from the database
    public function destroy(Employee $employee)
    {
        // Delete profile image if it exists
        if ($employee->profile && file_exists(public_path($employee->profile))) {
            unlink(public_path($employee->profile));
        }

        // Delete uploaded file if it exists
        if ($employee->file && file_exists(public_path($employee->file))) {
            unlink(public_path($employee->file));
        }

        // Delete associated user if exists
        if ($employee->user) {
            $employee->user->delete();
        }

        // Delete the employee record
        $employee->delete();

        return response()->json(['success' => true, 'message' => 'Record and files deleted successfully.']);
    }

    public function import(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'file' => 'required|mimes:xlsx,xls,csv',
        ]);

        if ($validator->fails()) {
            return response()->json(['errors' => $validator->errors()], 422);
        }

        try {
            $import = new EmployeeImport;
            Excel::import($import, $request->file('file'));

            $importedData = $import->getImportedRows(); // Successfully imported rows
            $skippedData = $import->getSkippedRows();   // Skipped rows with reasons

            return response()->json([
                'message' => 'Imported successfully!',
                'imported' => $importedData,
                'skipped' => $skippedData,
            ], 200);

        } catch (\Exception $e) {
            return response()->json([
                'message' => 'Failed to import data.',
                'error' => $e->getMessage()
            ], 500);
        }
    }


}
