<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Contribution;
use App\Models\MonthlyRate;

class ContributionController extends Controller
{

    public function index()
    {
        // Fetch the latest contributions for each benefit type
        // $sss = Contribution::where('benefit_name', 'SSS')->where('status', '1')->latest()->first();
        // $phil = Contribution::where('benefit_name', 'PhilHealth')->where('status', '1')->latest()->first();
        // $pag = Contribution::where('benefit_name', 'Pag-IBIG')->where('status', '1')->latest()->first();


        $contributions = Contribution::get();


        return view('contributions.index', compact('contributions'));
    }


    public function storeMonthlyRate(Request $request)
    {
        $request->validate([
            'contribution_id' => 'required|exists:contributions,id',
            'monthly_salary' => 'required|string|max:255',
        ]);

        MonthlyRate::create([
            'contribution_id' => $request->contribution_id,
            'monthly_salary' => $request->monthly_salary,
        ]);

        // Redirect back with a success message
        return redirect()->back()->with('success', 'Monthly Rate created successfully.');
    }
    public function create()
    {
        return view('contributions.create');
    }


    public function store(Request $request)
    {
        // Validate incoming request data
        $validated = $request->validate([
            'benefit_name' => 'required|string|max:255',
            'employee_percentage' => 'required|numeric|min:0',
            'employer_percentage' => 'required|numeric|min:0',
        ]);

        Contribution::create($validated);

        return redirect()->back()->with('success', 'Contribution added successfully.');
    }


    public function edit($id)
    {
        $contribution = Contribution::findOrFail($id);
        return view('contributions.edit', compact('contribution'));
    }


    public function update(Request $request, $id)
    {
        // Validate incoming request data
        $validated = $request->validate([
            'benefit_name' => 'nullable|string|max:255',
            'monthly_salary' => 'nullable|numeric|min:0',
            'employee_percentage' => 'nullable|numeric|min:0',
            'employer_percentage' => 'nullable|numeric|min:0',
        ]);

        // Find the contribution record and update it
        $contribution = Contribution::findOrFail($id);
        $contribution->update($validated);

        return redirect()->back()->with('success', 'Contribution updated successfully.');
    }


    public function destroy($id)
    {
        // Find and delete the contribution record
        $contribution = Contribution::findOrFail($id);
        $contribution->delete();

        return redirect()->back()->with('success', 'Contribution deleted successfully.');
    }
    public function salarydestroy($id)
    {
        // Find and delete the contribution record
        $contributionrate = MonthlyRate::findOrFail($id);
        $contributionrate->delete();

        return redirect()->back()->with('success', 'Contribution deleted successfully.');
    }
}
