<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Hash;
use App\Models\User;

class ChangePasswordController extends Controller
{
    // Show the change password form


    // Change the password
    public function changePassword(Request $request)
    {
        // Validate the request
        $request->validate([
            'current_password' => 'required',
            'new_password' => 'required|min:3|confirmed',
        ]);


        if (!Auth::check()) {
            return redirect()->route('login')->withErrors(['msg' => 'You must be logged in to change your password.']);
        }


        $user = User::find(Auth::id());


        if (!Hash::check($request->current_password, $user->password)) {
            return back()->withErrors(['current_password' => 'The current password is incorrect.']);
        }


        $user->password = Hash::make($request->new_password);
        $user->save(); // Persist the change

        return redirect()->back()->with('success', 'Password changed successfully!');
    }
}
