<?php

namespace App\Http\Controllers;


use App\Models\Assign;
use App\Models\Client;
use App\Models\Billing;
use App\Models\Charges;
use App\Models\Company;
use App\Models\Payroll;
use App\Models\Benefits;
use App\Models\Employee;


use Barryvdh\DomPDF\Facade\Pdf;
use App\Models\Batchcode;

use App\Models\Attendance;
use App\Models\Department;
use Illuminate\Http\Request;
use App\Models\AssignCompany;
use App\Models\PersonApprove;
use App\Models\PersonInCharge;
use Illuminate\Support\Carbon;
use App\Models\AdjustmentReport;
use App\Models\OthersForPayroll;
use Yajra\DataTables\DataTables;
use App\Models\BillingAdjustment;
use App\Models\ConstantDeduction;

use App\Models\SettingForBilling;
use App\Models\TRXloandeductions;
use Illuminate\Support\Facades\Auth;
use App\Models\EmployeeClientChannel;
use App\Models\AssignCompanyDepartment;


class BillingController extends Controller
{
    public function index1(Request $request, $id)
    {
        if ($request->ajax()) {
            $data = Payroll::with('employee.channelclient.department.client') // Adjust relationships
                ->whereHas('employee.channelclient.department.client', function ($query) use ($id) {
                    $query->whereHas('company', function ($query) use ($id) {
                        $query->where('id', $id);
                    });
                })
                ->get();

            return DataTables::of($data)
                ->addColumn('employee_name', function ($row) {
                    return $row->employee ? $row->employee->name : 'N/A';
                })
                ->addColumn('action', function ($row) {
                    $actionBtn = '<div class="flex items-center justify-center gap-2">
                        <a href="' . url('admin/company-billings/' . $row->code_id) . '" class="flex items-center justify-center w-10 h-10 text-white bg-green-600 rounded-md edit"><i class="text-xl bx bx-show"></i></a>
                          </div>';
                    return $actionBtn;
                })
                ->make(true);
        }
    }
    public function index(Request $request)
    {


        $user = Auth::user();

        $agencyIds = $user->viewable_agency_ids;

        $query = BatchCode::where('status', '2')->with('client');

        if (!empty($agencyIds)) {

            $query->whereHas('client.client.agency', function ($q) use ($agencyIds) {
                $q->whereIn('id', $agencyIds);
            });

            $assignIds = Assign::where('user_id', $user->id)
                ->whereIn('agency_id', $agencyIds)
                ->pluck('id');

            $restrictedCompanyIds = AssignCompany::whereIn('assign_id', $assignIds)
                ->pluck('id');

            $restrictedDepartmentIds = AssignCompanyDepartment::whereIn('assigncompany_id', $restrictedCompanyIds)
                ->pluck('department_id')
                ->unique();


            if ($restrictedDepartmentIds->isNotEmpty()) {
                $query->whereIn('department_id', $restrictedDepartmentIds);
            }
        }


        if ($request->ajax()) {
            $data = $query->get();

            return DataTables::of($data)
                ->addColumn('code_id', function ($row) {
                    return $row->payrolls->pluck('code_id')->unique()->first(); // Get the unique code_id
                })
                ->addColumn('client_id', function ($row) {
                    return $row->payrolls->pluck('client.department_name')->unique()->first(); // Access the client's name
                })
                ->addColumn('approve_by', function ($row) {
                    $user = PersonApprove::with('user')->where('batch_id', $row->id)->first();
                    return $user && $user->user ? $user->user->name : 'N/A';
                })
                ->addColumn('pay_period', function ($row) {
                    $startDate = Carbon::parse($row->pay_period_start)->format('F j, Y'); // formats as "January 21, 2025"
                    $endDate = Carbon::parse($row->pay_period_end)->format('F j, Y'); // formats as "January 25, 2025"
    
                    return $startDate . ' - ' . $endDate;
                })
                ->addColumn('action', function ($row) {
                    // Retrieve the unique client_id
                    $clientId = $row->payrolls->pluck('department_id')->unique()->first();

                    return '<div class="flex items-center justify-center gap-2">
                        <a href="' . url('admin/company-billings/' . $row->id . '/' . $clientId) . '" class="flex items-center justify-center w-10 h-10 text-white bg-green-600 rounded-md edit">
                            <i class="text-xl bx bx-show"></i>
                        </a>
                    </div>';
                })
                ->make(true);
        }

        return view('Admin.Billing.index');
    }


    public function final(Request $request)
    {

        $user = Auth::user();

        $agencyIds = $user->viewable_agency_ids;


        $query = BatchCode::where('status', '3')->with('client');

        if (!empty($agencyIds)) {

            $query->whereHas('client.client.agency', function ($q) use ($agencyIds) {
                $q->whereIn('id', $agencyIds);
            });


            $assignIds = Assign::where('user_id', $user->id)
                ->whereIn('agency_id', $agencyIds)
                ->pluck('id');

            $restrictedCompanyIds = AssignCompany::whereIn('assign_id', $assignIds)
                ->pluck('id');

            $restrictedDepartmentIds = AssignCompanyDepartment::whereIn('assigncompany_id', $restrictedCompanyIds)
                ->pluck('department_id')
                ->unique();


            if ($restrictedDepartmentIds->isNotEmpty()) {
                $query->whereIn('department_id', $restrictedDepartmentIds);
            }
        }


        if ($user->role_id === 8) {
            $query->whereHas('payrolls.client', function ($q) use ($user) {
                $q->where('user_id', $user->id);
            });
        }






        if ($request->ajax()) {
            $data = $query->get();

            return DataTables::of($data)
                ->addColumn('code_id', function ($row) {
                    return $row->payrolls->pluck('code_id')->unique()->first(); // Get the unique code_id
                })
                ->addColumn('client_id', function ($row) {
                    return $row->payrolls->pluck('client.department_name')->unique()->first(); // Access the client's name
                })
                ->addColumn('pay_period', function ($row) {
                    $startDate = Carbon::parse($row->pay_period_start)->format('F j, Y'); // formats as "January 21, 2025"
                    $endDate = Carbon::parse($row->pay_period_end)->format('F j, Y'); // formats as "January 25, 2025"
    
                    return $startDate . ' - ' . $endDate;
                })
                ->addColumn('approve_by', function ($row) {
                    $user = PersonApprove::with('user')->where('batch_id', $row->id)->first();
                    return $user && $user->user ? $user->user->name : 'N/A';
                })
                ->addColumn('action', function ($row) {
                    // Retrieve the unique client_id
                    $clientId = $row->payrolls->pluck('department_id')->unique()->first();
                    return '<div class="flex items-center justify-center gap-2">
            <a href="' . url('admin/company-billings/' . $row->id . '/' . $clientId . '?value=1') . '" class="flex items-center justify-center w-10 h-10 text-white bg-green-600 rounded-md edit">
                <i class="text-xl bx bx-show"></i>
            </a>
        </div>';
                })
                ->make(true);
        }

        return view('Admin.Billing.final');
    }



    public function clientbilling(Request $request, $id)
    {
        if ($request->ajax()) {
            // Fetch data only once.
            $data = BatchCode::where('status', '3')
                ->where('department_id', $id)
                ->with('client')
                ->get();

            return DataTables::of($data)
                ->addColumn('code_id', function ($row) {
                    return $row->id; // Unique Batch Code
                })
                ->addColumn('client_id', function ($row) {
                    // Use the 'client' relationship to get the client's department name
                    return $row->client ? $row->client->department_name : 'N/A';
                })
                ->addColumn('pay_period', function ($row) {
                    $startDate = Carbon::parse($row->pay_period_start)->format('F j, Y');
                    $endDate = Carbon::parse($row->pay_period_end)->format('F j, Y');
                    return $startDate . ' - ' . $endDate;
                })
                ->addColumn('approve_by', function ($row) {
                    $user = PersonApprove::with('user')->where('batch_id', $row->id)->first();
                    return ($user && $user->user) ? $user->user->name : 'N/A';
                })
                ->addColumn('action', function ($row) {
                    // Use the client's id if available
                    $clientId = $row->client ? $row->client->id : '';
                    return '<div class="flex items-center justify-center gap-2">
                                <a href="' . url('admin/company-billings/' . $row->id . '/' . $clientId . '?value=1') . '" class="flex items-center justify-center w-10 h-10 text-white bg-green-600 rounded-md edit">
                                    <i class="text-xl bx bx-show"></i>
                                </a>
                            </div>';
                })
                ->make(true);
        }
    }


    public function clientpayroll(Request $request, $id)
    {
        if ($request->ajax()) {
            // Fetch data only once.
            $data = BatchCode::where('status', '3')
                ->where('department_id', $id)
                ->with('client')
                ->get();

            return DataTables::of($data)
                ->addColumn('code_id', function ($row) {
                    return $row->id; // Unique Batch Code
                })
                ->addColumn('client_id', function ($row) {
                    // Use the 'client' relationship to get the client's department name
                    return $row->client ? $row->client->department_name : 'N/A';
                })
                ->addColumn('pay_period', function ($row) {
                    $startDate = Carbon::parse($row->pay_period_start)->format('F j, Y');
                    $endDate = Carbon::parse($row->pay_period_end)->format('F j, Y');
                    return $startDate . ' - ' . $endDate;
                })
                ->addColumn('approve_by', function ($row) {
                    $user = PersonApprove::with('user')->where('batch_id', $row->id)->first();
                    return ($user && $user->user) ? $user->user->name : 'N/A';
                })
                ->addColumn('action', function ($row) {
                    // Use the client's id if available
                    $clientId = $row->client ? $row->client->id : '';
                    return '<div class="flex items-center justify-center gap-2">
                                <a href="' . url('admin/company-billings/' . $row->id . '/' . $clientId . '?value=1') . '" class="flex items-center justify-center w-10 h-10 text-white bg-green-600 rounded-md edit">
                                    <i class="text-xl bx bx-show"></i>
                                </a>
                            </div>';
                })
                ->make(true);
        }
    }




    public function billings(Request $request, $id, $client_id = null)
    {

        $department = Department::find($client_id);

        $now = Carbon::now();



        $batchCode = Batchcode::find($id);
        if ($batchCode) {
            $hasBillingRecords = Billing::where('batch_id', $batchCode->id)->first();
        } else {
            $hasBillingRecords = false;  // If no batch code found, set false

        }
        $charges = Charges::where('department_id', $client_id)->get();

        // If department is found and billing status is 1
        if ($department && $department->billing_status == 1) {
            foreach ($charges as $charge) {
                // Retrieve the associated Batchcode scope dates
                $scopeStart = Carbon::parse($batchCode->scope_start);
                $scopeEnd = Carbon::parse($batchCode->scope_end);

                // Retrieve the charge's start and end dates
                $chargeStartDate = Carbon::parse($charge->start_date);
                $chargeEndDate = Carbon::parse($charge->end_date);

                // Check if the charge's date range falls within the Batchcode's scope
                if ($chargeStartDate->lte($scopeEnd) && $chargeEndDate->gte($scopeStart)) {
                    $charge->status = 1; // Active if charge's date range overlaps with scope
                } else {
                    $charge->status = null; // Inactive if charge's date range is outside scope
                }

                // Save the updated charge status
                $charge->save();
            }
        }


        // Get the latest charge
        if ($hasBillingRecords) {
            $latestCharge = Charges::with('chargeGroups')->find($hasBillingRecords->charge_id);
        } else {
            $latestCharge = Charges::with('chargeGroups')->where('department_id', $client_id)->where('status', '1')->first();
        }



        // Retrieve client information only if client_id is provided
        $client = $client_id ? Department::find($client_id) : null;

        // Check if there's any payroll with status = 1 for the provided batch and client (if client_id is set)
        $hasStatusOneQuery = Payroll::where('code_id', $id)->where('status', 1);
        if ($client_id) {
            $hasStatusOneQuery->where('department_id', $client_id);
        }
        $hasStatusOne = $hasStatusOneQuery->exists();


        $payrolls = Payroll::with(['trxLoanDeductions.trxLoan.trx_code', 'trxConstantDeductions.trxConstant.trx_code', 'othersForPayroll', 'benefits.client'])
            ->where('code_id', $id)

            ->get();

        $payrollCount = Payroll::where('code_id', $id)->count();
        $adjustment = AdjustmentReport::with('employee')->where('batch_id', $id)->get();
        // $settings = SettingForBilling::where('client_id', $client_id)->latest()->first();
        return view('Admin.Client.Billings.index', compact(

            'payrollCount',
            'client',
            'client_id',
            'id',

            'hasBillingRecords',
            'latestCharge',
            'adjustment',
            'payrolls',
            'batchCode'

        ));
    }

    public function getBillingId()
    {
        return $this->billingAdjustments()->first()?->billing_id;
    }

    public function store(Request $request)
    {
        $request->validate([
            'user_id' => 'required|exists:users,id', // Ensure user exists
            'batch_id' => 'required|exists:batchcode,id', // Ensure batch_id exists in batchcode table
            'charge_id' => 'required|exists:charges,id',
            'note' => 'nullable|string',
        ]);

        // Ensure batch_id exists in the batchcode table
        $batchCode = Batchcode::find($request->input('batch_id'));

        if (!$batchCode) {
            return redirect()->back()->with('error', 'Invalid batch ID.');
        }

        $billing = Billing::create([
            'user_id' => $request->input('user_id'),
            'batch_id' => $request->input('batch_id'),
            'charge_id' => $request->input('charge_id'),
            'note' => $request->input('note', ''), // Default to an empty string if no note
            'date' => now(),
        ]);

        // Update batch status if found
        $batchCode->status = 3;
        $batchCode->save();

        return redirect()->back()->with('success', 'Billing saved successfully!');
    }



    public function updateBatchStatus(Request $request)
    {
        $id = $request->input('id');


        $personId = auth()->user()->id;

        $batch = Batchcode::find($id);

        if ($batch) {
            if ($batch->status == 0) {

                PersonIncharge::create([
                    'batch_id' => $batch->id,
                    'person_incharge_id' => $personId,
                    'status' => 'Finished Preparing',
                ]);
                $status = 1;
                $batch->status = $status;
                $batch->save();

                $payPeriodStart = Carbon::parse($batch->pay_period_start)->format('F j, Y');
                $payPeriodEnd = Carbon::parse($batch->pay_period_end)->format('F j, Y');


                return redirect()->back()->with('success', 'Batch ' . $id . ' has been set as the Final Payroll with a pay period from ' . $payPeriodStart . ' to ' . $payPeriodEnd . '.');
            } elseif ($batch->status == 1) {

                PersonApprove::create([
                    'batch_id' => $batch->id,
                    'person_approved_id' => $personId,
                    'status' => 'Approved',
                ]);


                $status = 2;
                $batch->status = $status;
                $batch->save();


                $payPeriodStart = Carbon::parse($batch->pay_period_start)->format('F j, Y');
                $payPeriodEnd = Carbon::parse($batch->pay_period_end)->format('F j, Y');


                return redirect()->back()->with('success', 'Batch ' . $id . ' has been approved as the Final Payroll with a pay period from ' . $payPeriodStart . ' to ' . $payPeriodEnd . '.');
            } else {
                // If batch status is neither 0 nor 1, return an error
                return redirect()->back()->with('error', 'Batch not found or already processed.');
            }
        } else {
            // If the batch does not exist, return an error
            return redirect()->back()->with('error', 'Batch not found.');
        }
    }

    public function edit($id)
    {
        $payroll = Payroll::findOrFail($id);

        $benefits = Benefits::where('payroll_id', $id)->get();

        $loan_deductions = TRXloandeductions::where('payroll_id', $id)->get();

        $constantearning = ConstantDeduction::where('payroll_id', $id)->get();

        $others = OthersForPayroll::where('payroll_id', $id)->get();

        // Pass the data to the view
        return view('Admin.Client.Billings.edit', compact(
            'payroll',
            'loan_deductions',
            'benefits',
            'constantearning',
            'others'
        ));
    }
    public function update(Request $request, $id)
    {
        $request->validate([
            'loan_deductions.amount' => 'array',
            'constant_deductions.amount' => 'array',
            'others.amount' => 'array',
            'benefits.employee_share' => 'array',
            'benefits.type' => 'array',
            'rate' => 'required|numeric',
            'days_worked_withdeduction' => 'required|numeric',
        ]);

        $payroll = Payroll::findOrFail($id);

        $newRate = (float) $request->input('rate');
        $newDays = (float) $request->input('days_worked_withdeduction');
        $newEarnings = $newRate * $newDays;

        $oldRate = (float) $payroll->getOriginal('rate_adjustment');
        $oldDays = (float) $payroll->getOriginal('days_adjustment');
        $oldEarnings = (float) $payroll->getOriginal('earnings_adjustment');

        $isRateChanged = $oldRate !== $newRate;
        $isDaysChanged = $oldDays !== $newDays;
        $isEarningsChanged = $newEarnings !== $oldEarnings && ($isRateChanged || $isDaysChanged);

        $batchcodeUpdated = false;

        // Only update payroll if any value changed
        if ($isRateChanged || $isDaysChanged || $isEarningsChanged) {
            $payroll->rate_adjustment = $newRate;
            $payroll->days_adjustment = $newDays;
            $payroll->earnings_adjustment = $newEarnings;
            $payroll->update();
        }

        // RATE ADJUSTMENT
        if ($isRateChanged) {
            $under = max(0, $oldRate - $newRate);
            $over = max(0, $newRate - $oldRate);

            AdjustmentReport::create([
                'batch_id' => $payroll->code_id,
                'employee_id' => $payroll->employee_id,
                'action' => 'Rate Adjustment',
                'remarks' => "Rate: $oldRate → $newRate",
                'underpayment' => $under,
                'overpayment' => $over,
            ]);
            $batchcodeUpdated = true;
        }

        // DAYS WORKED ADJUSTMENT
        if ($isDaysChanged) {
            $under = max(0, $oldDays - $newDays);
            $over = max(0, $newDays - $oldDays);

            AdjustmentReport::create([
                'batch_id' => $payroll->code_id,
                'employee_id' => $payroll->employee_id,
                'action' => 'Days Worked Adjustment',
                'remarks' => "Days Worked: $oldDays → $newDays",
                'underpayment' => $under,
                'overpayment' => $over,
            ]);
            $batchcodeUpdated = true;
        }

        // EARNINGS ADJUSTMENT
        if ($isEarningsChanged) {
            $under = max(0, $oldEarnings - $newEarnings);
            $over = max(0, $newEarnings - $oldEarnings);

            AdjustmentReport::create([
                'batch_id' => $payroll->code_id,
                'employee_id' => $payroll->employee_id,
                'action' => 'Earnings Adjustment ',
                'remarks' => "Earnings: $oldEarnings → $newEarnings",
                'underpayment' => $under,
                'overpayment' => $over,
            ]);
            $batchcodeUpdated = true;
        }


        if ($request->has('loan_deductions')) {
            foreach ($request->loan_deductions['id'] as $index => $loan_id) {
                $loanDeduction = TRXloandeductions::find($loan_id);
                if ($loanDeduction) {
                    $old = (float) $loanDeduction->getOriginal('amount_ad');
                    $new = (float) $request->loan_deductions['amount'][$index];

                    if ($old !== $new) {
                        $under = max(0, $old - $new);
                        $over = max(0, $new - $old);

                        $loanDeduction->update(['amount_ad' => $new]);
                        $batchcodeUpdated = true;

                        AdjustmentReport::create([
                            'batch_id' => $payroll->code_id,
                            'employee_id' => $payroll->employee_id,
                            'action' => 'Loan Deduction Adjustment ',
                            'remarks' => "Loan ID: $loan_id, Amount: $old → $new",
                            'underpayment' => $under,
                            'overpayment' => $over,
                        ]);
                    }
                }
            }
        }

        // CONSTANT DEDUCTIONS
        if ($request->has('constant_deductions')) {
            foreach ($request->constant_deductions['id'] as $index => $constant_id) {
                $constant = ConstantDeduction::find($constant_id);
                if ($constant) {
                    $old = (float) $constant->getOriginal('er_amount_ad');
                    $new = (float) $request->constant_deductions['amount'][$index];

                    if ($old !== $new) {
                        $under = max(0, $old - $new);
                        $over = max(0, $new - $old);

                        $constant->update(['er_amount_ad' => $new]);
                        $batchcodeUpdated = true;

                        AdjustmentReport::create([
                            'batch_id' => $payroll->code_id,
                            'employee_id' => $payroll->employee_id,
                            'action' => 'Constant Adjustment',
                            'remarks' => "Constant ID: $constant_id, Amount: $old → $new",
                            'underpayment' => $under,
                            'overpayment' => $over,
                        ]);
                    }
                }
            }
        }

        // OTHERS
        if ($request->has('others')) {
            foreach ($request->others['id'] as $index => $other_id) {
                $other = OthersForPayroll::find($other_id);
                if ($other) {
                    $old = (float) $other->getOriginal('amount_adj');
                    $new = (float) $request->others['amount'][$index];

                    if ($old !== $new) {
                        $under = max(0, $old - $new);
                        $over = max(0, $new - $old);

                        $other->update(['amount_adj' => $new]);
                        $batchcodeUpdated = true;

                        AdjustmentReport::create([
                            'batch_id' => $payroll->code_id,
                            'employee_id' => $payroll->employee_id,
                            'action' => 'Other Adjustment',
                            'remarks' => "Other ID: $other_id, Amount: $old → $new",
                            'underpayment' => $under,
                            'overpayment' => $over,
                        ]);
                    }
                }
            }
        }

        // BENEFITS
        if ($request->has('benefits')) {
            foreach ($request->benefits['id'] as $index => $benefit_id) {
                $benefit = Benefits::find($benefit_id);
                if ($benefit) {
                    $oldType = $benefit->getOriginal('type');
                    $newType = $request->benefits['type'][$index];
                    $oldAmount = (float) $benefit->getOriginal('er_adjustment');
                    $newAmount = (float) $request->benefits['employee_share'][$index];

                    if ($oldType !== $newType || $oldAmount !== $newAmount) {
                        $benefit->update([
                            'type' => $newType,
                            'er_adjustment' => $newAmount,
                        ]);
                        $batchcodeUpdated = true;

                        $under = max(0, $oldAmount - $newAmount);
                        $over = max(0, $newAmount - $oldAmount);

                        AdjustmentReport::create([
                            'batch_id' => $payroll->code_id,
                            'employee_id' => $payroll->employee_id,
                            'action' => 'Benefit Adjustment',
                            'remarks' => "Benefit ID: $benefit_id, Type: $oldType → $newType, Amount: $oldAmount → $newAmount",
                            'underpayment' => $under,
                            'overpayment' => $over,
                        ]);
                    }
                }
            }
        }

        if ($batchcodeUpdated) {
            $batchcode = Batchcode::find($payroll->code_id);
            if ($batchcode) {
                $batchcode->with_adjustment = 1;
                $batchcode->save();
            }
        }

        return redirect()->back()->with('success', 'Billing Adjustment successfully!');
    }




    public function downloadReport($batchId)
    {


        $client = Batchcode::with('client.client.agency')->find($batchId);


        // Get adjustment reports related to this billing
        $adjustment = AdjustmentReport::where('batch_id', $batchId)->where('status', 1)
            ->with('employee')  // eager load employee relation
            ->get();

        if ($client) {
            $hasBillingRecords = Billing::where('batch_id', $client->id)->first();
        } else {
            $hasBillingRecords = false;  // If no batch code found, set false

        }


        // Generate PDF
        $pdf = Pdf::loadView('Admin.Client.Billings.pdfvreport', compact('adjustment', 'client', 'hasBillingRecords'));

        return $pdf->download('Variance_report.pdf');
    }

    public function destroyadjustment($id)
    {
        $adjustment = AdjustmentReport::findOrFail($id);
        $adjustment->delete();

        // Return JSON response for Axios
        return response()->json([
            'success' => true,
            'message' => 'Adjustment report deleted successfully.'
        ]);
    }
    public function saveadjustment($id)
    {
        // Update all matching adjustment reports with batchcode = $id
        $adjustment = AdjustmentReport::findOrFail($id);
        $adjustment->status = 1; // Set status to 1
        $adjustment->save();

        // Return JSON response for Axios
        return response()->json([
            'success' => true,
            'message' => 'Adjustment saved successfully.'
        ]);
    }
}
