<?php

namespace App\Http\Controllers;

use Yajra\DataTables\DataTables;
use App\Models\User;
use App\Models\Agency;
use App\Models\Client;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Auth;


class AgencyController extends Controller
{

    public function index(Request $request)
    {
        $privileges = $request->get('privileges');
        $user = Auth::user();


        $query = Agency::with('user')->orderBy('created_at', 'desc');

        $agencyIds = $user->viewable_agency_ids;
        if (!empty($agencyIds)) {
            $query->whereIn('id', $agencyIds);
        }


        if ($request->ajax()) {
            $data = $query->get();

            return DataTables::of($data)

                ->addColumn('image', function ($row) {
                    $actionBtn = '<div class="flex items-center justify-center gap-2">';

                    // Display the image using the contact_person field which contains the image path
                    $actionBtn .= '<img src="' . asset($row->contact_person) . '" alt="Logo" width="50" height="50">'; // Adjust size as needed

                    $actionBtn .= '</div>';
                    return $actionBtn;
                })

                ->addColumn('action', function ($row) use ($privileges) {
                    $actionBtn = '<div class="flex items-center justify-center gap-2">';

                    if (in_array('Manage Agency', $privileges)) {
                        $actionBtn .= '<a href="' . url('admin/agency-profile/' . $row->id) . '" class="flex items-center justify-center w-10 h-10 text-white bg-green-600 rounded-md edit"><i class="text-xl bx bx-show"></i></a>';
                    }

                    if (in_array('Edit Agency', $privileges)) {
                        $actionBtn .= '<button onclick="openModal(\'updateModal' . $row->id . '\')" class="flex items-center justify-center w-10 h-10 text-white bg-blue-600 rounded-md edit"><i class="bx bx-edit-alt"></i></button>';
                    }

                    if (in_array('Delete Agency', $privileges)) {
                        $actionBtn .= '<button onclick="openModal(\'deleteModal' . $row->id . '\')" class="flex items-center justify-center w-10 h-10 text-white bg-red-600 rounded-md delete"><i class="text-xl bx bx-trash-alt"></i></button>';
                    }

                    $actionBtn .= '</div>';
                    return $actionBtn;
                })
                ->rawColumns(['image', 'action'])
                ->make(true);
        }

        $data = $query->get();
        return view('Admin.Agency.index', compact('data'));
    }

    public function showemagencydetails(Request $request, $id)
    {
        if ($request->ajax()) {
            $data = Client::with('user')->where('agency_id', $id)->orderby('created_at', 'desc')->get();
            return DataTables::of($data)
                ->addColumn('action', function ($row) {
                    $actionBtn = '<div class="flex items-center justify-center gap-2">
                    <a href="' . url('admin/company-profile/' . $row->id) . '" class="flex items-center justify-center w-10 h-10 text-white bg-green-600 rounded-md edit"><i class="text-xl bx bx-show"></i></a>
                   
                </div>';
                    return $actionBtn;
                })
                ->make(true);
        }
        $agency = Agency::with('user')->find($id);
        return view('Admin.Agency.agencyprofile', compact('agency'));
    }


    public function store(Request $request)
    {
        $request->validate([
            'name' => 'required|string|max:255',
            'contact_phone' => 'required|string|max:20',
            'address' => 'required|string|max:255',
        ]);

        // Default email
        $defaultEmail = 'default@example.com';

        // Step 1: Create the user without the password
        $user = User::create([
            'name' => $request->name,
            'email' => $defaultEmail, // Use default email
            'password' => '', // Temporary placeholder
            'role_id' => 2,
        ]);

        // Step 2: Update the password to include user_id for uniqueness
        $uniquePassword = 'password123' . $user->id; // Combine default password with user_id
        $user->update([
            'password' => Hash::make($uniquePassword), // Hash the unique password
        ]);

        // Handle image upload if provided
        $picturePath = null;
        if ($request->hasFile('image')) {
            $file = $request->file('image');
            $file_name = time() . '.' . $file->getClientOriginalExtension();
            $destination = public_path('uploads');
            $file->move($destination, $file_name);
            $picturePath = 'uploads/' . $file_name;
        }

        // Create the agency record
        Agency::create([
            'user_id' => $user->id,
            'name' => $request->name,
            'contact_person' => $picturePath,
            'contact_phone' => $request->contact_phone,
            'address' => $request->address,
        ]);

        return redirect()->route('agencies.index')->with('success', 'Agency created successfully.');
    }


    public function show(Agency $agency)
    {
        return view('agencies.show', compact('agency'));
    }

    public function edit(Agency $agency)
    {
        return view('agencies.edit', compact('agency'));
    }

    public function update(Request $request, Agency $agency)
    {
        $request->validate([
            'name' => 'required|string|max:255',
            'image' => 'nullable|image|mimes:jpeg,png,jpg,gif,svg', // Validate the image
            'contact_phone' => 'required|string|max:20',
            'address' => 'required|string|max:255',
        ]);


        $picturePath = $agency->contact_person; // Retain existing image path if 
        if ($request->hasFile('image')) {
           
           $oldImagePath = public_path($agency->contact_person);

if (!empty($agency->contact_person) && file_exists($oldImagePath) && is_file($oldImagePath)) {
    unlink($oldImagePath);
}
           

            // Handle the new image upload
            $file = $request->file('image');
            $file_name = time() . '.' . $file->getClientOriginalExtension();
            $destination = public_path('uploads');
            $file->move($destination, $file_name);
            $picturePath = 'uploads/' . $file_name;
        }

        // Update agency data
        $agency->update([
            'name' => $request->name,
            'contact_person' => $picturePath,  // Save the image path in 'contact_person' field
            'contact_phone' => $request->contact_phone,
            'address' => $request->address,
        ]);

        return redirect()->route('agencies.index')->with('success', $agency->name . ' agency updated successfully.');
    }


    public function destroy(Agency $agency)
    {
        $agency->delete();
        return redirect()->route('agencies.index')->with('success', 'Agency deleted successfully.');
    }
}
