<!DOCTYPE html>
<html>
<head>
	<meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">

    <!-- CSRF Token -->
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">
	<?php echo $__env->yieldContent('meta'); ?>

	<link rel="preconnect" href="https://fonts.googleapis.com">
	<link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
	<link href="https://fonts.googleapis.com/css2?family=Assistant:wght@400;500;700&family=Red+Hat+Display:ital,wght@0,400;0,700;1,400;1,700&family=Sanchez:ital@0;1&display=swap" rel="stylesheet">
	<link rel="stylesheet" type="text/css" href="<?php echo e(asset('css/front.min.css')); ?>">
</head>
<body>
	<?php if(Session::has('message') OR $errors->any()): ?>
    <div class="modal fade" role="dialog" id="modalMessage">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5>Message</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    <?php if($errors->any()): ?>
                        <?php echo $__env->make('include.alert', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                    <?php else: ?>
                        <?php echo e(Session::get('message')); ?>

                        <?php echo e(Session::forget('message')); ?>

                    <?php endif; ?>
                </div>
            </div>
        </div>
    </div>
    <?php endif; ?>
	<div class="container-fluid" id="top_header">
		<div class="row">
			<div class="col-lg-9 my-auto">
				<ol class="list-inline mb-0">
					<li class="list-inline-item">
						<p class="mb-0">
							<i class="fas fa-map-marker-alt brown"></i>
							<span class="font-weight-bold">Address</span>
							Panacan Avenue, KM12, Sasa, Davao City, Philippines
						</p>
					</li>
					<li class="list-inline-item">
						<p class="mb-0">
							<i class="fas fa-phone brown"></i>
							<span class="font-weight-bold">Call us</span>
							(082) 235 1246
						</p>
					</li>
					<li class="list-inline-item">
						<p class="mb-0">
							<i class="fas fa-paper-plane brown"></i>
							<span class="font-weight-bold">Write us</span>
							sales@davaofibre.ph
						</p>
					</li>
				</ol>
			</div>
			<div class="col-lg-3 text-right">
				<a href="" target="_blank" class="btn btn_icon">
					<i class="fab fa-facebook-f"></i>
				</a>
				<a href="" target="_blank" class="btn btn_icon">
					<i class="fab fa-twitter"></i>
				</a>
				<a href="" target="_blank" class="btn btn_icon">
					<i class="fab fa-instagram"></i>
				</a>
				<a href="" target="_blank" class="btn btn_icon">
					<i class="fab fa-linkedin-in"></i>
				</a>
			</div>
		</div>
	</div>
	<header class="sticky-top">
		<nav class="navbar navbar-expand-xl navbar-light bg-transparent" id="navigation">
			<a href="" class="navbar-brand font-weight-bold">
				<img src="<?php echo e(asset('images/fibre-transparent.png')); ?>" class="img-fluid">
			</a>
			<button class="navbar-toggler" type="button" data-toggle="collapse" data-target="#navbarCollapse" aria-controls="navbarCollapse" aria-expanded="false" aria-label="Toggle navigation">
				<span class="navbar-toggler-icon"></span>
			</button>

			<div class="collapse navbar-collapse" id="navbarCollapse">
				<ul class="navbar-nav mr-auto">
					<li class="nav-item">
						<a class="nav-link hvr-shutter-out-horizontal" href="<?php echo e(url('/')); ?>">Home</a>
					</li>
					<li class="nav-item" id="navAbout">
						<a class="nav-link hvr-shutter-out-horizontal" href="#">About us</a>
						<div class="dropdown-about">
							<a href="<?php echo e(url('history')); ?>" class="dropdown-item">History</a>
							<a href="<?php echo e(url('about')); ?>" class="dropdown-item">Mission & Vision</a>
							<a href="<?php echo e(url('contact-us')); ?>" class="dropdown-item">Contact us</a>
						</div>
					</li>
					<li class="nav-item">
						<a class="nav-link hvr-shutter-out-horizontal" href="<?php echo e(url('products')); ?>">Our Products</a>
					</li>
					<li class="nav-item">
						<a class="nav-link hvr-shutter-out-horizontal" href="<?php echo e(url('blogs')); ?>">Blogs</a>
					</li>
					<li class="nav-item" id="navAbout">
						<a class="nav-link hvr-shutter-out-horizontal" href="#">News & Events</a>
						<div class="dropdown-about">
							<a href="<?php echo e(url('news')); ?>" class="dropdown-item">News</a>
							<a href="<?php echo e(url('events')); ?>" class="dropdown-item">Events</a>
						</div>
					</li>
					<!-- <li class="nav-item">
						<a class="nav-link hvr-shutter-out-horizontal" href="<?php echo e(url('/')); ?>">Contact us</a>
					</li> -->
					<li class="nav-item">
						<a class="nav-link hvr-shutter-out-horizontal" href="<?php echo e(url('/')); ?>">Corrulated Box</a>
					</li>
				</ul>
				<ul class="form-inline my-2 my-lg-0">
			      	<a href="tel: (082) 235 1246" class="btn btn_brown font-weight-bold px-3 my-2 my-sm-0 rounded-pill" type="submit">
						<i class="fas fa-phone"></i>
				      	(082) 235 1246
				    </a>
			    </ul>
			</div>
		</nav>
	</header>

	<?php echo $__env->yieldContent('content'); ?>

	<footer>
		<div class="container">
			<div class="row">
				<div class="col-md-2 pb-md-0 pb-3">
					<img src="<?php echo e(asset('images/fibre-transparent.png')); ?>" class="img-fluid">
				</div>
				<div class="col-md-3 col-sm-6">
					<h5>Our Services</h5>
					<ol>
						<li>
							<a href="">DFPPI People</a>
						</li>
						<li>
							<a href="">Box pricing</a>
						</li>
						<li>
							<a href="">Client testimonials</a>
						</li>
						<li>
							<a href="">Our philosophy and process</a>
						</li>
						<li>
							<a href="">Cost Calculator</a>
						</li>
						<li>
							<a href="">Our location</a>
						</li>
					</ol>
				</div>
				<div class="col-md-3 col-sm-6">
					<h5>About DFPPI</h5>
					<ol>
						<li>
							<a href="">DFPPI People</a>
						</li>
						<li>
							<a href="">Box pricing</a>
						</li>
						<li>
							<a href="">Client testimonials</a>
						</li>
						<li>
							<a href="">Our philosophy and process</a>
						</li>
						<li>
							<a href="">Cost Calculator</a>
						</li>
						<li>
							<a href="">Our location</a>
						</li>
					</ol>
				</div>
				<div class="col-md-3">
					<h5>Connect with us</h5>
					<p class="mb-0">
						<a href="" target="_blank" class="btn btn_icon">
							<i class="fab fa-facebook-f"></i>
						</a>
						<a href="" target="_blank" class="btn btn_icon">
							<i class="fab fa-twitter"></i>
						</a>
						<a href="" target="_blank" class="btn btn_icon">
							<i class="fab fa-instagram"></i>
						</a>
						<a href="" target="_blank" class="btn btn_icon">
							<i class="fab fa-linkedin-in"></i>
						</a>
					</p>
					<p class="text-justify">
						Subscribe to our newsletter to receive the latest news, releases, updates and special offers from Davao Fibreboard Packaging Plant, Inc.
					</p>
					<form class="form-inline my-2 my-lg-0 newsletterForm" method="post" action="<?php echo e(route('send.newsletter')); ?>">
						<?php echo csrf_field(); ?>
				      	<input class="form-control mr-sm-2" type="email" name="email" value="<?php echo e(old('email')); ?>" placeholder="Email Address" aria-label="Email Address">
				      	<button class="btn btn_brown rounded-circle" type="submit"><i class="fas fa-paper-plane"></i></button>
				    </form>
				</div>
				<div class="col-xl-12 text-center pt-4">
					<p class="mb-0">
						©<?php echo e(date('Y')); ?> Davao Fiberboard Packaging Inc.
						All rights reserved. Developed by
						<a href="" target="_blank" class="text-white"> R Web Solutions Corp. </a>
					</p>
				</div>
			</div>
		</div>
	</footer>

	<script src="<?php echo e(asset('js/front.min.js')); ?>"></script>
	<script type="text/javascript">
        $(window).on('load', function() {
            $('#modalMessage').modal('show');
        });
    </script>
	<?php echo $__env->yieldContent('js'); ?>
</body>
</html><?php /**PATH C:\xampp\htdocs\projects\fiberboard\resources\views/layouts/front/app.blade.php ENDPATH**/ ?>