
<?php $__env->startSection('meta'); ?>
	<title>Corrugated Box | <?php echo e(env('APP_NAME')); ?></title>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
	<section id="page_header" style="background-image: url(<?php echo e(asset('images/group.jpg')); ?>)" class="wow fadeIn" data-wow-duration="2s">
		<div class="container-fluid page_overlay">
			<div class="container">
				<div class="row">
					<div class="col-lg-5 my-auto">
						<p class="mb-0 wow bounceInDown" data-wow-duration="2s">Home <i class="fa fa-chevron-right mx-1"></i>Corrugated Box</p>
						
						<h1 class="wow bounceInRight" data-wow-duration="2s">
							High Quality    
							<u>Customized Box</u>
							<span class="passion">
								
							</span>
						</h1>
					</div>
				</div>
			</div>
		</div>
	</section>

	<div class="container-fluid" id="productList">
		<div class="row">
			<div class="col-xl-7 wow fadeInLeft" data-wow-duration="2s">
				<form method="post" class="" action="<?php echo e(route('send.product-calculate')); ?>" enctype="multipart/form-data">
					<?php echo csrf_field(); ?>
					<div class="row">
						<div class="form-group col-lg-6">
							<input type="text" name="name" value="<?php echo e(old('name')); ?>" placeholder="Full Name" class="form-control" required="">
						</div>
						<div class="form-group col-lg-6">
							<input type="number" name="phone_num" value="<?php echo e(old('phone_num')); ?>" placeholder="Phone number" class="form-control" required="">
						</div>
						<div class="form-group col-lg-6">
							<input type="email" name="email" value="<?php echo e(old('email')); ?>" placeholder="Email" class="form-control" required="">
						</div>
						<div class="form-group col-lg-6">
							<input type="number" name="quantity" id="quantity" value="<?php echo e(old('quantity')); ?>" placeholder="Quantity" class="form-control" required="">
						</div>
												
						<div class="form-group col-lg-6">
							<input type="date" name="deliver_date" value="<?php echo e(old('deliver_date')); ?>" placeholder="Turnaround Time" class="form-control" >
							<small>Turnaround Date</small>
						</div>
						<div class="form-group col-lg-6">
							<div class="input-group">
							  	<div class="custom-file">
							    	<input type="file" class="custom-file-input" name="docu" id="file" accept=".pdf">
							    	<label class="custom-file-label" for="inputGroupFile01">Choose file</label>
							  	</div>
							</div>
							
	                        <small> File (.pdf) Should be less than 1mb *</small>
						</div>
						<div class="form-group col-lg-12">
							<select name="paper_type" id="paper_type" class="form-control" required="">
								<option>- Select Box Type -</option>
								<option value="3kg banana box">3kg banana box - $0.42/set</option>
								<option value="5kg banana box">5kg banana box - $0.56/set</option>
								<option value="7kg banana box">7kg banana box - $0.95/set</option>
								<option value="13kg brown banana box">13kg brown banana box - $1.11/set</option>
								<option value="13kg white banana box">13kg white banana box - $1.14/set</option>
								<option value="18kg brown banana box (frescana specs)">18kg brown banana box (frescana specs) - $1.38/set</option>
								<option value="18kg brown banana box (utpi specs)">18kg brown banana box (utpi specs) - $1.55/set</option>
								<option value="12kg pineapple tray type box">12kg pineapple tray type box -$1.23/box</option>
							</select>
							
						</div>
						
						
						<div class="form-group col-lg-12">
							<textarea name="note" class="form-control" rows="5" placeholder="Additional Information"><?php echo e(old('note')); ?></textarea>
						</div>
						
						<div class="form-group col-lg-12">
							<H4>
								<span class="font-weight-bold">Total: </span>
								<span id="total">₱ 0.00</span>
							</H4>
							<input type="text" name="total" id="totalVal" hidden="">
						</div>
						<div class="form-group col-lg-12 text-center">
							<div class="btn-group mr-2" role="group" aria-label="Second group">
							    <button type="submit" class="btn btn_brown">GET A QUOTE</button>
								<button type="submit" class="btn btn_dbrown">
									<i class="fas fa-paper-plane"></i>
								</button>
							</div>
						</div>
					</div>
						
				</form>
			</div>
			<div class="col-xl-5 text-center wow fadeInRight" data-wow-duration="2s">
				<div class="carousel slide" data-ride="carousel" id="corrugatedCarousel">
					<div class="carousel-inner">
						<div class="carousel-item active">
							<img src="<?php echo e(asset('images/1.jpg')); ?>" class="img-fluid">
						</div>
						<div class="carousel-item">
							<img src="<?php echo e(asset('images/2.jpg')); ?>" class="img-fluid">
						</div>
						<div class="carousel-item">
							<img src="<?php echo e(asset('images/3.jpg')); ?>" class="img-fluid">
						</div>
						<div class="carousel-item">
							<img src="<?php echo e(asset('images/4.jpg')); ?>" class="img-fluid">
						</div>
					</div>
					<ol class="carousel-indicators">
					    <li data-target="#corrugatedCarousel" data-slide-to="0" class="active">
							<img src="<?php echo e(asset('images/1.jpg')); ?>" class="img-fluid">
					    </li>
					    <li data-target="#corrugatedCarousel" data-slide-to="1">
							<img src="<?php echo e(asset('images/2.jpg')); ?>" class="img-fluid">
					    </li>
					    <li data-target="#corrugatedCarousel" data-slide-to="2">
							<img src="<?php echo e(asset('images/3.jpg')); ?>" class="img-fluid">
					    </li>
					    <li data-target="#corrugatedCarousel" data-slide-to="3">
							<img src="<?php echo e(asset('images/4.jpg')); ?>" class="img-fluid">
					    </li>
					</ol>
				</div>
			</div>
		</div>
	</div>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('js'); ?>
	<script src="<?php echo e(asset('js/buttonfile.min.js')); ?>"></script>
	<script type="text/javascript">
		$(document).ready(function () {
		  bsCustomFileInput.init()
		});
		var total = 0;
		$('#paper_type').change(function(event) {
			id = $(this).val();
			quan = 1;
			if($('#quantity').val()){
				quan = $('#quantity').val();
			}

			if(id == '3kg banana box'){
				total = 0.42;
			}
			else if(id == '5kg banana box'){
				total = 0.56;
			}
			else if(id == '7kg banana box'){
				total = 0.95;
			}
			else if(id == '13kg brown banana box'){
				total = 1.11;
			}
			else if(id == '13kg white banana box'){
				total = 1.14;
			}
			else if(id == '18kg brown banana box (frescana specs)'){
				total = 1.38;
			}
			else if(id == '18kg brown banana box (utpi specs)'){
				total = 1.55;
			}
			else if(id == '12kg pineapple tray type box'){
				total = 1.23;
			}
			document.getElementById("total").innerHTML = '$ '+(total*quan);
			$('#totalVal').val(total*quan);
		  	// alert(total);
		});

		$('#quantity').change(function(event) {
			// total = $('#quantity').val();
			quan = $(this).val();
			document.getElementById("total").innerHTML = '$ '+(total*quan);
			$('#totalVal').val(total*quan);
		});
	</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.front.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/rwsserver/public_html/davaofiberboard/resources/views/front/corrugated.blade.php ENDPATH**/ ?>