@extends('layouts.admin.app')
@section('meta')
    <link rel="stylesheet" type="text/css" href="{{ asset('css/email.min.css') }}">
@stop
@section('content')
	<div class="modal fade text-left" id="deleteModal" tabindex="-1" role="dialog" aria-labelledby="myModalLabel120" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered modal-dialog-scrollable" role="document">
            <div class="modal-content">
                <div class="modal-header bg-danger white">
                    <h5 class="modal-title" id="myModalLabel120">Delete Data</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    Are you sure you want to delete this data?
                </div>
                <div class="modal-footer">
                    <form method="post" action="{{ url('delete/1') }}" class="btn-ok"> @csrf @method('delete')
                    	<button type="submit" class="btn btn-danger">
                    	  	Yes
                    	</button>
                  	</form>
					<button type="button" class="btn btn-primary" data-dismiss="modal">No</button>
                </div>
            </div>
        </div>
    </div>
	<div class="app-content content" id="table-hover-animation">
        <div class="content-overlay"></div>
        <div class="header-navbar-shadow"></div>
        <div class="content-wrapper">
            <div class="content-header row">
                <div class="content-header-left col-md-9 col-12 mb-2">
                    <div class="row breadcrumbs">
                        <div class="col-12">
                            <h2 class="content-header-title float-left mb-0">List View</h2>
                            <div class="breadcrumb-wrapper col-12">
                                <ol class="breadcrumb">
                                    <li class="breadcrumb-item">
                                    	<a href="{{ url('home') }}">Home</a>
                                    </li>
                                    {{-- <li class="breadcrumb-item">
                                    	<a href="#">Data List</a>
                                    </li> --}}
                                    <li class="breadcrumb-item">
                                    	Text Images Management
                                    </li>
                                    <li class="breadcrumb-item active">
                                    	Home
                                    </li>
                                </ol>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            @include('include.alert')
            
            <div class="content-body">
                <!-- Data list view starts -->
                <div class="email-application">
                    <div class="content-area-wrapper mt-0">
                        <div class="sidebar-left">
                            <div class="sidebar">
                                <div class="sidebar-content email-app-sidebar">
                                    <div class="email-app-menu">
                                        {{-- <div class="form-group-compose text-center compose-btn">
                                            <button type="button" class="compose-email btn btn-primary btn-block" data-backdrop="false" data-toggle="modal" data-target="#compose-mail">
                                                Compose
                                            </button>
                                        </div> --}}
                                        <div class="sidebar-menu-list" style="overflow-x: hidden;">
                                            <div class="list-group list-group-messages">
                                                <a href="#item1" class="list-group-item list-group-item-action active">
                                                    <i data-feather="image" class="font-medium-3 mr-50"></i>
                                                    <span class="align-middle">Banners</span>
                                                    {{-- <span class="badge badge-light-primary badge-pill float-right">0</span> --}}
                                                </a>
                                            </div>
                                        </div>
                                    </div>
                                </div>

                            </div>
                        </div>
                        @php
                            $model = App\Models\Page\TextImagesManagement\NewsEventsContent::class;
                            $banner1 = $model::findorFail(1);
                        @endphp
                        <div class="content-right">
                            <div class="content-wrapper" style="height: unset;">
                                <div class="content-header row">
                                </div>

                                <div class="body-content-overlay"></div>
                                <!-- Email list Area -->
                                <div class="email-app-list">
                                    <!-- Email search starts -->
                                    <div class="app-fixed-search d-flex align-items-center">
                                        <div class="sidebar-toggle d-block d-lg-none ml-1">
                                            <i data-feather="menu" class="font-medium-5"></i>
                                        </div>
                                        <div class="d-flex align-content-center justify-content-between w-100">
                                            <div class="input-group input-group-merge">
                                                <div class="input-group-prepend">
                                                    <span class="input-group-text"><i data-feather="dash" class="text-muted"></i></span>
                                                </div>
                                                {{-- <input type="text" class="form-control" id="email-search" placeholder="Search email" aria-label="Search..." aria-describedby="email-search" /> --}}
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="content-body">
                                    <div id="item1" class="body-content-overlay py-2 fw-bold fa-2x"><h3>Banners</h3></div>
                                    <div  class="">
                                        <h5 class="py-2 mb-0">Banner 1</h5>
                                        <div class="content-body bg-white p-3">
                                            <div class="content-body bg-white p-3">
                                                <div class="align-items-center mb-3">
                                                    <p>Current Image: {{$banner1->file}}</p>
                                                    <img style="width: 200px;" src="{{asset('/uploads/news-events-content/'.$banner1->file )}}">
                                                </div>
                                                <form method="post" class="row" action="{{ url('Admin/Text-Images-Management/News-Events-Content/1') }}" enctype="multipart/form-data">@csrf @method('put')
                                                    <div class="form-group col-xl-12">
                                                        <small> Image Should be less than 1mb</small>
                                                        <div class="input-group">
                                                            <div class="custom-file">
                                                                <input type="file" class="custom-file-input file" data-type="img" name="file" id="file" accept=".png,.jpeg,.jpg">
                                                                <label class="custom-file-label light_gray" for="exampleInputFile">UPLOAD ONE(1) IMAGE WITH DIMENSIONS (1200x700)</label>
                                                            </div>
                                                        </div>
                                                        <div class="alert-col">
                                                        </div>
                                                        <div class="gallery">
                                                        </div>
                                                    </div>

                                                    <div class="form-group col-lg-12">
                                                        <small>Title*</small>
                                                        <input type="text" name="title" class="form-control" value="{{ old('title') ? old('title') : $banner1->title }}" placeholder="Title" >
                                                    </div>
                                                    
                                                    <div class="form-group text-center col-xl-12">
                                                        <button class="btn btn-primary submit" type="submit">UPDATE</button>
                                                    </div>
                                                </form>
                                            </div>
                                        </div>
                                        
                                    </div>
                                    <hr>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    {{-- @foreach($data as $value)
    @include('module.story.update')
    @endforeach --}}
@endsection
@section('js')
    <script src="{{ asset('js/email.min.js') }}"></script>
    <script src="//cdn.ckeditor.com/4.13.0/standard/ckeditor.js"></script>
	<script>
	</script>
	<script>
        CKEDITOR.replace('me3');
        CKEDITOR.replace('me4');
	  $(function () {
	    // $("#example1").DataTable();
	    $('#example1').DataTable({
	      "paging": true,
	      "pageLength": 50,
	      "lengthChange": true,
	      "searching": true,
	      "ordering": false,
	      "info": true,
	      "autoWidth": false,
	    });
	    $('.select2').select2();
	    $('.select2bs4').select2({
	      theme: 'bootstrap4'
	    });
	  });
	  	$('.delte').click(function () {
			var id = $(this).data('href');
			$('.btn-ok').attr('action', id);
			$('#deleteModal').modal('show');
		});

        $('.email-media-list li').click(function(event) {
            id = $(this).attr('data-id');
            $('.email-app-details').removeClass('show');
            $('#email'+id).addClass('show');
        });

        $('.file').each(function(){
            var error = $(this).parent().parent().siblings().first()
            var prevImg = $(this).parent().parent().next().next()
            var submit = $(this).parent().parent().parent().next().next().children().first()
            let data = $(this).data()

            // console.log(submit)
            let minFsize = null
            var uploadField = this
            
            if (data.type == 'vid') {
                minFsize = 24800
            } else {
                minFsize = 1048
            }
            
            uploadField.onchange = function() {
                const fsize = this.files[0].size;
                const file = Math.round((fsize / minFsize)); 
                // console.log(fsize)
                if (file >= minFsize) { 
                    $(this).addClass('is-invalid');
                    error.html(`<small class="text-danger">File too Big, please select a file less than ${minFsize}mb </small>`);
                    submit.prop('disabled', true);
                }else{
                    $(this).removeClass('is-invalid');
                    error.html('');
                    submit.prop('disabled', false);
                }
            };
    

            $(this).change(function () {
                if (data.type == 'vid') {
                    var fileUrl = window.URL.createObjectURL(this.files[0]);
                    $(".video").attr("src", fileUrl);
                }else{
                    prevImg.children().remove();
                    imagesPreview(this, prevImg);
                }
            });

        })

        function imagesPreview(input, placeToInsertImagePreview) {
            if (input.files) {
                var filesAmount = input.files.length;
                for (i = 0; i < filesAmount; i++) {
                    var reader = new FileReader();
                    reader.onload = function(event) {
                        $($.parseHTML('<img class="img-fluid">')).attr('src', event.target.result).appendTo(placeToInsertImagePreview);
                    }
                    reader.readAsDataURL(input.files[i]);
                }
            }
        };


	</script>
@endsection