<div class="card blog_sidebar">
	<div class="card-header">
		<form method="post" class="searchForm" action="{{ route('search') }}">
			@csrf
			<div class="input-group mb-3">
			  	<input type="text" class="form-control" name="keyword" placeholder="Looking for..." aria-label="keyword" aria-describedby="basic-addon2">
			  	<div class="input-group-append">
			    	<button class="btn" id="button-addon2" type="submit"><i class="fas fa-search"></i></button>
			  	</div>
			</div>
		</form>
	</div>
	@if(count($news) > 0)
	<div class="card-body">
		<h5 class="title">Recent Posts</h5>
		<ol class="list-group list-group-flush" id="recent_list">
			@foreach($events as $recent_post)
			
				@if ($recent_post->id == $event->id)
					
				@else
				<li class="list-group-item px-0">
					<div class="card">
						  <div class="row no-gutters">
							<div class="col-4 my-auto">
								  <img src="{{ asset('uploads/events/'.$recent_post->image) }}" class="img-fluid" alt="">
							</div>
							<div class="col-8 my-auto">
								  <div class="card-body pr-0 py-0">
									<p class="mb-0">{{ date('M j, Y', strtotime($recent_post->created_at)) }}</p>
									<a href="{{ url('events/'.str_replace([' ', '/'], ['_', '`'], $recent_post->title)) }}" class=" font-weight-bold">{{ Str::limit($recent_post->title, 30)}}</a>
								  </div>
							</div>
						  </div>
					</div>
				</li>
				@endif

			@endforeach
		</ol>
	</div>
	@endif
	{{-- <div class="card-body">
		<h5 class="title">Archives</h5>
		<ol class="list-group list-group-flush" id="recent_list">
			@foreach($archives as $arc)
			<li class="list-group-item d-flex justify-content-between align-items-center px-0">
				<a href="">{{ date('F Y', strtotime($arc->created_at)) }}</a>
				<span class="badge brown badge-pill">1</span>
			</li>
			@endforeach
		</ol>
	</div> --}}
	{{-- <div class="card-body">
		<h5 class="title">Tags</h5>
		<ol class="list-inline">
		</ol>
		@foreach($tags as $tag)
		<li class="list-inline-item">
			<form method="post" action="{{ route('tags') }}">
				@csrf
				<input type="id" name="id" value="{{ $tag->id }}" hidden="">
				<button class="btn btn_tag hvr-shutter-out-horizontal">{{ $tag->name }}</button>
			</form>
		</li>
		@endforeach
	</div> --}}
</div>