<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use App\Models\Client;


class Project extends Model
{
    use HasFactory;

    protected $fillable = [
        'client_id',
    	'title',
        'operating_unit',
        'clients',
        'work',
        'project',
        'area',
        'division',
        'man_hours',
        'content',
        'status',
        'active'
    ];

    public function client(){
        return $this->belongsTo(Client::class, 'client_id');
    }
}
