<?php

namespace App\Http\Controllers;

use App\Http\Requests;
use App\Http\Controllers\CalculationController as Calculate;
use App\Models\Product;
use App\Models\Order;
use Illuminate\Http\Request;
use Validator;
use URL;
use Session;
use Redirect;
use Input;
use PayPal\Rest\ApiContext;
use PayPal\Auth\OAuthTokenCredential;
use PayPal\Api\Amount;
use PayPal\Api\Details;
use PayPal\Api\Item;
use PayPal\Api\ItemList;
use PayPal\Api\Payer;
use PayPal\Api\Payment;
use PayPal\Api\CustomAmount;
use PayPal\Api\RedirectUrls;
use PayPal\Api\ExecutePayment;
use PayPal\Api\PaymentExecution;
use PayPal\Api\Transaction;
use PayPal\Api\BillingInfo;
use App\Mail\OrderMail;
use Illuminate\Support\Facades\Mail;



class PaypalController extends Controller
{
    private $_api_context;
    
    public function __construct()
    {
        $paypal_configuration = \Config::get('paypalcon');
        $this->_api_context = new ApiContext(new OAuthTokenCredential($paypal_configuration['client_id'], $paypal_configuration['secret']));
        $this->_api_context->setConfig($paypal_configuration['settings']);
    }

    // public function payWithPaypal()
    // {
    //     return view('front.merch');
    // }

    public function postPaymentWithpaypal(Request $request)
    {
        // return $request;
        // return \Config::get('paypalcon');
        $order = (object) session('order');
        
        $product = Product::findOrFail($order->product_id);
        
        // return $product;
        $discount = 0;
        if (in_array($order->promo_code, ['HeySexy15','TheDreWay']) ) {
            $discount = .15;
        }
        // $price = 59.99;
        $price = new Calculate($product->price, $order->qty, $discount);
        // return floatval($product->price) - (floatval($product->price) * $discount);

        $payer = new Payer();
        $payer->setPaymentMethod('paypal');

    	$item_1 = new Item();

        $item_1->setName($product->name.' - '.$order->size)
            ->setCurrency('USD')
            ->setQuantity($order->qty)
            ->setPrice( floatval($product->price) - (floatval($product->price) * $discount) );

        $item_list = new ItemList();
        $item_list->setItems(array($item_1));

        $details = new Details();
        $details->setSubtotal($price->total());
        // $details->setShipping(1)
            // ->setTax(1)
            // ->setShippingDiscount(1)
            // ->setSubtotal(20);
            
        $amount = new Amount();
        $amount->setCurrency('USD')
            ->setTotal($price->total()) //mustbe total to all price
            ->setDetails($details);

        $transaction = new Transaction();
        $transaction->setAmount($amount)
            ->setItemList($item_list)
            ->setDescription('Size: '.$order->size);

        $redirect_urls = new RedirectUrls();
        $redirect_urls->setReturnUrl(URL::route('status'))
            ->setCancelUrl(URL::route('status'));

        $payment = new Payment();
        $payment->setIntent('Sale')
            ->setPayer($payer)
            ->setRedirectUrls($redirect_urls)
            ->setTransactions(array($transaction));            
        try {
            $payment->create($this->_api_context);
        } catch (\PayPal\Exception\PPConnectionException $ex) {
            if (\Config::get('app.debug')) {
                return back()->with('warning','Connection timeout');            
            } else {
                return back()->with('warning','Some error occur, sorry for inconvenient');           
            }
        }

        foreach($payment->getLinks() as $link) {
            if($link->getRel() == 'approval_url') {
                $redirect_url = $link->getHref();
                break;
            }
        }
        
        Session::put('paypal_payment_id', $payment->getId());

        if(isset($redirect_url)) {            
            return Redirect::away($redirect_url);
        }

    	return back()->with('error','Unknown error occurred');
    }

    public function getPaymentStatus(Request $request)
    {        
        try {
            $order = (object) session('order');
            $bill_details = (object) session('bill_details');
            $payment_id = Session::get('paypal_payment_id');

            Session::forget('paypal_payment_id');
            if (empty($request->input('PayerID')) || empty($request->input('token'))) {
                return back()->with('warning','Payment failed');
            }
            
            $payment = Payment::get($payment_id, $this->_api_context);        
            $execution = new PaymentExecution();
            $execution->setPayerId($request->input('PayerID'));        
            $result = $payment->execute($execution, $this->_api_context);
            
            if ($result->getState() == 'approved') {  

                $discount = 0;
                if (in_array($order->promo_code, ['HeySexy15','TheDreWay']) ) {
                    $discount = .15;
                }
                $product = Product::findOrFail($order->product_id);

                $price = new Calculate($product->price, $order->qty, $discount);

                $result = (object) json_decode($result);
    
                $info = $result->payer->payer_info;
                $address = $result->payer->payer_info->shipping_address;
                $transactions = $result->transactions[0];
    
                $bill_name = $info->first_name.' '.$info->last_name;
                $bill_email = $info->email;
                $bill_address = $address->line1.' '.$address->city.' '.$address->state.' '.$address->postal_code.' '.$address->country_code;
    
                $total_amount = $transactions->amount->total;
                $items = $transactions->item_list->items;
                
                Order::create([
                    'user_id' => \Auth::check() ? auth()->user()->id : null,
                    'order_no' => 'TD-ODR-' . date('Ymdh') . Order::count() + 1,
                    'bill_name' => $bill_name,
                    'bill_email' => $bill_email,
                    'bill_mobile' => $bill_details->bill_phone,
                    'bill_address' => $bill_address,
                    'payment_method' => 'paypal',
                    'payment_reference' => $result->id,
                    'payment_status' => $result->state,
                    'order_items' => json_encode($items),
                    'promo_code' => $order->promo_code,
                    'discount' => $discount,
                    // 'card_fee' => ,
                    // 'status' => $status,
                    'total_amount_due' => $total_amount,
                    'discounted' => number_format(($price->total() * $discount) * $order->qty , 2),
                ]);
                
    
                // dd($result->transactions);
                $bill_email = $result->payer->payer_info->email;
                
                // dd(number_format(($price->total() * $discount) * $order->qty , 2));
                // Mail::to($bill_email)->cc(env('MAIL_CC_ADDRESS'))->send(new OrderMail($result, 'paypal'));
                return back()->with('success','Payment success !!');
            }
    
            return back()->with('warning','Payment failed !!');
            //code...
        } catch (\Throwable $th) {
            return back()->with('warning','Payment failed !!');
        }
    }
}