<?php

namespace App\Http\Controllers;

use App\Models\Applicants;
use Illuminate\Http\Request;

class ApplicantsController extends Controller
{
    public function index()
    {
        $data = Applicants::with('career')->latest()->get();
        return view('module.applicants.index', compact('data'));
    }


    public function store(Request $request)
    {
        $request->validate([
            'career_id' => 'required|exists:careers,id',
            'name' => 'required|string|max:255',
            'contact_number' => 'nullable|string|max:20',
            'email' => 'nullable|email|max:255',
            'address' => 'nullable|string|max:255',
            'resume' => 'nullable|file|max:2048|mimes:pdf,doc,docx',
        ]);

        $data = $request->except('resume');

        if ($request->hasFile('resume')) {
            $file = $request->file('resume');
            $fileName = time() . '_' . $file->getClientOriginalName();
            $filePath = 'resumes/' . $fileName;

            $file->move(public_path('resumes'), $fileName); // Move file to public/resumes folder
            $data['resume'] = $filePath;
        }

        Applicants::create($data);

        return redirect()->back()->with('success', 'Successfully added new applicant');
    }

    public function destroy($id)
    {
        // return $id;
        $data = Applicants::findOrFail($id);
        $data->delete();

        return back()->with('success', 'Successfully deleted Applicant');
    }
}
