<?php

namespace App\Http\Controllers\Admin\Page;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Contact;
use Validator;
use App\Mail\ContactMail;
use Illuminate\Support\Facades\Mail;



class ContactController extends Controller
{
    public function index()
    {
        $data = Contact::latest()->get();
        return view('module.contact.index', compact('data'));
    }
    
    public function store(Request $request)
    {
        // dd($request);

        $validator = Validator::make($request->all(), [
            'name' => ['required', 'string', 'max:255'],
            'email' => ['required', 'string', 'email', 'max:255'],
            'phone' => ['required', 'string', 'digits:11'],
            'subject' => ['required', 'string', 'max:255'],
            'message' => ['required', 'string', 'max:255'],
        ]);

        if($validator->fails()){
            return back()->withInput()->withErrors($validator);
        }

        Contact::create([
            'phone' => $request->phone,
            'subject' => $request->subject,
            'message' => $request->message,
            'name' => $request->name,
            'email' => $request->email,
        ]);

        Mail::to($request->email)->cc(env('MAIL_CC_ADDRESS'))->send(new ContactMail($request));

        return back()->with('message', 'Thank you for contacting us. We will update you through your email.');
    }

    
    public function destroy($id)
    {
        Contact::findOrFail($id)->delete();

        return back()->with('success', 'Successfully deleted contact');
    }
}
