<?php

namespace App\Http\Controllers\Admin\Page;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Career;
use Validator;
use Str;

class CareerController extends Controller
{
    public function index()
    {
        $data = Career::latest()->get();
        return view('module.careers.index', compact('data'));
    }


    public function create()
    {
        return view('module.careers.create');
    }


    public function store(Request $request)
    {
        $request->validate([
            'type' => 'required',
            'title' => 'required',
            'department' => 'required',
            'location' => 'required',
            'content' => 'required',
            'active' => 'required',
        ]);

        Career::create([
            'type' => $request->type,
            'title' => $request->title,
            'department' => $request->department,
            'location' => $request->location,
            'content' => $request->content,
            'active' => $request->active,
        ]);

        return redirect('admin/careers')->with('success', 'Successfully added new Career');
    }


    public function show($id)
    {
        //
    }


    public function edit($id)
    {
        $data = Career::findOrFail($id);
        return view('module.careers.update', compact('data'));
    }


    public function update(Request $request, $id)
    {

        $career = Career::findOrFail($id);

        $career->update([
            'type' => $request->type,
            'title' => $request->title,
            'department' => $request->department,
            'location' => $request->location,
            'content' => $request->content,
            'active' => $request->active,
        ]);

        return back()->with('success', 'Successfully updated Career');
    }


    public function destroy($id)
    {
        // return $id;
        $data = Career::findOrFail($id);
        $data->delete();

        return back()->with('success', 'Successfully deleted Career');
    }

    public function uploadFile($path, $file)
    {
        $path = public_path() . $path;
        $filename = date_format(date_create(), 'mdyHis') . Str::random(5) . '.' . $file->getClientOriginalExtension();
        $file->move($path, $filename);
        return $filename;
    }
}
