<!DOCTYPE html>
<html>
<head>
	<meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">

    <!-- CSRF Token -->
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">
    <meta property="og:url" content="http://rwebcart.com/dev/fiberboard/public/">
    <meta property="og:type" content="website">
    <meta property="og:title" content="Davao Fiberboard Packaging Inc.">
    <meta property="og:description" content="Davao Fiberboard Packaging Plant, Inc. (DFPPI) is a manufacturing of high quality corrugated carton boxes and other packaging materials. Incorporated on December 27, 2007, it is formed to cater a wider-range of customers and more diverse markets.">
    <meta property="og:site_name" content="Davao Fiberboard Packaging Inc.">
    <meta property="og:image" content="http://rwebcart.com/dev/fiberboard/public/images/thumbnail.jpg">
    <meta name="keywords" content="davao, fiberboard, packaging, precision, quality, parts production, corrugated machines, quality boxes, box">
    <meta name="author" content="Davao Fiberboard Packaging Inc.">

	<?php echo $__env->yieldContent('meta'); ?>

	<link rel="apple-touch-icon" href="<?php echo e(asset('images/favicon.ico')); ?>">
    <link rel="shortcut icon" type="image/x-icon" href="<?php echo e(asset('images/favicon.ico')); ?>">
	<link rel="preconnect" href="https://fonts.googleapis.com">
	<link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
	
	<link href="https://fonts.googleapis.com/css2?family=Hind+Siliguri:wght@300;400;500;600;700&display=swap" rel="stylesheet">
	<link rel="stylesheet" type="text/css" href="<?php echo e(asset('css/front.min.css')); ?>">
</head>
<body>
	<div id="preloader" >
		<center>
			<div id="preload"><img src="<?php echo e(asset('images/fibre-transparent.png')); ?>" class="img-fluid"></div>
		</center>
	</div>
	<?php if(Session::has('message') OR $errors->any()): ?>
	<div class="modal fade" id="modalMessage" tabindex="-1">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header text-right ml-auto pr-0">
                    <button type="button" class="btn btn_brown rounded-circle" data-dismiss="modal">
                        <i class="fas fa-times"></i>
                    </button>
                </div>
                <div class="modal-body">
                    <?php if($errors->any()): ?>
                        <?php echo $__env->make('include.alert', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                    <?php else: ?>
                        <?php echo e(Session::get('message')); ?>

                        <?php echo e(Session::forget('message')); ?>

                    <?php endif; ?>
                </div>
            </div>
        </div>
    </div>
    <?php endif; ?>
	<div id="wrapper">
		
	    <section id="top_header">
			<div class="container" id="">
				<div class="row">
					<div class="col-lg-9 my-auto">
						<ol class="list-inline mb-0">
							
							<li class="list-inline-item">
								<p class="mb-0">
									<i class="fas fa-phone brown"></i>
									<span class="font-weight-bold">Call us</span>
									(082) 235 1246
								</p>
							</li>
							<li class="list-inline-item">
								<p class="mb-0">
									<i class="fas fa-paper-plane brown"></i>
									<span class="font-weight-bold">Write us</span>
									sales@davaofibre.ph
								</p>
							</li>
						</ol>
					</div>
					<div class="col-lg-3 text-right">
						<a href="" target="_blank" class="btn btn_icon">
							<i class="fab fa-facebook-f"></i>
						</a>
						<a href="" target="_blank" class="btn btn_icon">
							<i class="fab fa-twitter"></i>
						</a>
						<a href="" target="_blank" class="btn btn_icon">
							<i class="fab fa-instagram"></i>
						</a>
						<a href="" target="_blank" class="btn btn_icon">
							<i class="fab fa-linkedin-in"></i>
						</a>
					</div>
				</div>
			</div>
		</section>
		<header class="sticky-top">
			<div class="container">
				<div class="row">
					<nav class="navbar navbar-expand-xl navbar-light bg-transparent col-xl-12" id="navigation">
						<a href="" class="navbar-brand font-weight-bold">
							<img src="<?php echo e(asset('images/fibre-transparent.png')); ?>" class="img-fluid">
						</a>
						<button class="navbar-toggler" type="button" data-toggle="collapse" data-target="#navbarCollapse" aria-controls="navbarCollapse" aria-expanded="false" aria-label="Toggle navigation">
							<span class="navbar-toggler-icon"></span>
						</button>

						<div class="collapse navbar-collapse" id="navbarCollapse">
							<ul class="navbar-nav ml-auto">
								<li class="nav-item">
									<a class="nav-link hvr-shutter-out-horizontal <?php echo e(Request::is('/') ? 'active' : null); ?>" href="<?php echo e(url('/')); ?>">Home</a>
								</li>
								<li class="nav-item" id="navAbout">
									<a class="nav-link hvr-shutter-out-horizontal" href="#">About us</a>
									<div class="dropdown-about">
										<a href="<?php echo e(url('history')); ?>" class="dropdown-item">History</a>
										<a href="<?php echo e(url('about')); ?>" class="dropdown-item">Mission & Vision</a>
										<a href="<?php echo e(url('contact-us')); ?>" class="dropdown-item">Contact us</a>
									</div>
								</li>
								<li class="nav-item">
									<a class="nav-link hvr-shutter-out-horizontal <?php echo e(Request::is('products') ? 'active' : null); ?><?php echo e(Route::is('product_details') ? 'active' : null); ?>" href="<?php echo e(url('products')); ?>">Our Products</a>
								</li>
								<li class="nav-item">
									<a class="nav-link hvr-shutter-out-horizontal <?php echo e(Request::is('blogs') ? 'active' : null); ?>" href="<?php echo e(url('blogs')); ?>">Blogs</a>
								</li>
								<li class="nav-item" id="navAbout">
									<a class="nav-link hvr-shutter-out-horizontal <?php echo e(Request::is('news') ? 'active' : null); ?><?php echo e(Request::is('events') ? 'active' : null); ?>" href="#">News & Events</a>
									<div class="dropdown-about">
										<a href="<?php echo e(url('news')); ?>" class="dropdown-item">News</a>
										<a href="<?php echo e(url('events')); ?>" class="dropdown-item">Events</a>
									</div>
								</li>
								<!-- <li class="nav-item">
									<a class="nav-link hvr-shutter-out-horizontal" href="<?php echo e(url('/')); ?>">Contact us</a>
								</li> -->
								<li class="nav-item">
									<a class="nav-link hvr-shutter-out-horizontal <?php echo e(Request::is('corrugated-box') ? 'active' : null); ?>" href="<?php echo e(url('corrugated-box')); ?>">Corrugated Box</a>
								</li>
							</ul>
							<ul class="form-inline my-2 my-lg-0">
						      	<a href="tel: (082) 235 1246" class="btn btn_brown font-weight-bold px-3 my-2 my-sm-0 " type="submit">
									<i class="fas fa-phone"></i>
							      	(082) 235 1246
							    </a>
						    </ul>
						</div>
					</nav>
				</div>
			</div>
		</header>

		<?php echo $__env->yieldContent('content'); ?>

		<footer>
			<div class="container">
				<div class="row">
					<div class="col-md-4 pb-md-0 pb-3 pr-md-3">
						<img src="<?php echo e(asset('images/fibre-transparent.png')); ?>" class="img-fluid">
						<p>
							Davao Fiberboard Packaging Plant, Inc. (DFPPI) is a manufacturing of high quality corrugated carton boxes and other packaging materials. Incorporated on December 27, 2007, it is formed to cater a wider-range of customers and more diverse markets.
						</p>
					</div>
					<div class="col-md-4 col-sm-6">
						<h5>Latest News</h5>
						<ol>
							<li>
								<a href="#">Precision & Quality</a>
							</li>
							<li>
								<a href="#">Parts Production</a>
							</li>
							<li>
								<a href="#">Corrugated Machines</a>
							</li>
							<li>
								<a href="#">Quality Boxes</a>
							</li>
						</ol>
					</div>
					
					<div class="col-md-4">
						<h5>Connect with us</h5>
						<p class="mb-0">
							<a href="" target="_blank" class="btn btn_icon">
								<i class="fab fa-facebook-f"></i>
							</a>
							<a href="" target="_blank" class="btn btn_icon">
								<i class="fab fa-twitter"></i>
							</a>
							<a href="" target="_blank" class="btn btn_icon">
								<i class="fab fa-instagram"></i>
							</a>
							<a href="" target="_blank" class="btn btn_icon">
								<i class="fab fa-linkedin-in"></i>
							</a>
						</p>
						<p class="text-justify">
							Subscribe to our newsletter to receive the latest news, releases, updates and special offers from Davao Fibreboard Packaging Plant, Inc.
						</p>
						<form class="form-inline my-2 my-lg-0 newsletterForm" method="post" action="<?php echo e(route('send.newsletter')); ?>">
							<?php echo csrf_field(); ?>
					      	<input class="form-control mr-sm-2" type="email" name="email" value="<?php echo e(old('email')); ?>" placeholder="Email Address" aria-label="Email Address">
					      	<button class="btn btn_brown rounded-circle" type="submit"><i class="fas fa-paper-plane"></i></button>
					    </form>
					</div>
					<div class="col-xl-12 text-center pt-4">
						<p class="mb-0">
							©<?php echo e(date('Y')); ?> Davao Fiberboard Packaging Inc.
							All rights reserved. Developed by
							<a href="http://rwebsolutions.com.ph/" target="_blank" class="text-white"> R Web Solutions Corp. </a>
						</p>
					</div>
				</div>
			</div>
		</footer>
	</div>

	<button onclick="topFunction()" id="myBtn" title="Go to top">
        <span class="fa fa-arrow-up fa-2x"></span>
    </button>

	<script src="<?php echo e(asset('js/front.min.js')); ?>"></script>
	<script type="text/javascript">
        $(window).on('load', function() {
            $('#modalMessage').modal('show');

			setTimeout(showPage);

			function showPage() {
			  	document.getElementById("preloader").style.opacity = "0";
			  	$("#preloader").css({
			  		'z-index': '0'
			  	});
			  	document.getElementById("wrapper").style.visibility = "visible";
			}
        });
        window.onscroll = function() {scrollFunction()};
		mybutton = document.getElementById("myBtn");
	     function scrollFunction() {
	      if (document.body.scrollTop > 20 || document.documentElement.scrollTop > 20) {
	        mybutton.style.display = "block";
	      } else {
	        mybutton.style.display = "none";
	      }
	    }
	    function topFunction() {
	      document.body.scrollTop = 0; // For Safari
	      document.documentElement.scrollTop = 0; // For Chrome, Firefox, IE and Opera
	    }

    </script>
	<?php echo $__env->yieldContent('js'); ?>
</body>
</html><?php /**PATH C:\xampp\htdocs\dev\dfiberboard\resources\views/layouts/front/app.blade.php ENDPATH**/ ?>