<!DOCTYPE html>
<html>
<head>
	<meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">

	<?php echo $__env->yieldContent('meta'); ?>

  <!-- favicons Icons -->
  <link rel="apple-touch-icon" sizes="180x180" href="<?php echo e(asset('/images/favicons/apple-touch-icon.png')); ?>" />
  <link rel="icon" type="image/png" sizes="32x32" href="<?php echo e(asset('/images/favicons/favicon-32x32.png')); ?>" />
  <link rel="icon" type="image/png" sizes="16x16" href="<?php echo e(asset('/images/favicons/favicon-16x16.png')); ?>" />
  <link rel="manifest" href="<?php echo e(asset('/images/favicons/site.webmanifest')); ?>" />

  <!-- fonts -->
  <link rel="preconnect" href="https://fonts.googleapis.com">
  <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
  <link href="https://fonts.googleapis.com/css2?family=Roboto:ital,wght@0,100;0,300;0,400;0,500;0,700;0,900;1,100;1,300;1,400;1,500;1,700;1,900&display=swap" rel="stylesheet">

  <link rel="stylesheet" href="<?php echo e(asset('/vendors/bootstrap/css/bootstrap.min.css')); ?>" />
  <link rel="stylesheet" href="<?php echo e(asset('/vendors/animate/animate.min.css')); ?>" />
  <link rel="stylesheet" href="<?php echo e(asset('/vendors/animate/custom-animate.css')); ?>" />
  <link rel="stylesheet" href="<?php echo e(asset('/vendors/fontawesome/css/all.min.css')); ?>" />
  <link rel="stylesheet" href="<?php echo e(asset('/vendors/jarallax/jarallax.css')); ?>" />
  <link rel="stylesheet" href="<?php echo e(asset('/vendors/jquery-magnific-popup/jquery.magnific-popup.css')); ?>" />
  <link rel="stylesheet" href="<?php echo e(asset('/vendors/nouislider/nouislider.min.css')); ?>" />
  <link rel="stylesheet" href="<?php echo e(asset('vendors/nouislider/nouislider.pips.css')); ?>/" />
  <link rel="stylesheet" href="<?php echo e(asset('/vendors/odometer/odometer.min.css')); ?>" />
  <link rel="stylesheet" href="<?php echo e(asset('/vendors/swiper/swiper.min.css')); ?>" />
  <link rel="stylesheet" href="<?php echo e(asset('/vendors/kontin-icons/style.css')); ?>">
  <link rel="stylesheet" href="<?php echo e(asset('/vendors/tiny-slider/tiny-slider.min.css')); ?>" />
  <link rel="stylesheet" href="<?php echo e(asset('/vendors/reey-font/stylesheet.css')); ?>" />
  <link rel="stylesheet" href="<?php echo e(asset('/vendors/owl-carousel/owl.carousel.min.css')); ?>" />
  <link rel="stylesheet" href="<?php echo e(asset('/vendors/owl-carousel/owl.theme.default.min.css')); ?>" />
  <link rel="stylesheet" href="<?php echo e(asset('/vendors/twentytwenty/twentytwenty.css')); ?>" />
  <link rel="stylesheet" href="<?php echo e(asset('/vendors/bxslider/jquery.bxslider.css')); ?>" />
  <link rel="stylesheet" href="<?php echo e(asset('/vendors/bootstrap-select/css/bootstrap-select.min.css')); ?>" />
  <link rel="stylesheet" href="<?php echo e(asset('/vendors/vegas/vegas.min.css')); ?>" />
  <link rel="stylesheet" href="<?php echo e(asset('/vendors/jquery-ui/jquery-ui.css')); ?>" />
  <link rel="stylesheet" href="<?php echo e(asset('/vendors/timepicker/timePicker.css')); ?>" />

  <!-- template styles -->
  <link rel="stylesheet" href="<?php echo e(asset('/css/kontin.css')); ?>" />
  <link rel="stylesheet" href="<?php echo e(asset('/css/kontin-responsive.css')); ?>" />

	<?php echo $__env->yieldContent('css'); ?>
  <style>
    .active-subnav{
      background-color: #b00818 !important;
      color: #fff !important;
    }
    .active-insidenav{
      color: var(--thm-primary);
    }
    .text-website-primary{
      color: #b00818 !important;
    }
    .text-website-secondary{
      color: #ffc000 !important;
    }

  </style>
</head>

<body style="max-width: 1600px;" class="mx-auto">
	<div class="preloader">
    <img class="preloader__image" width="60" src="<?php echo e(asset('/images/loader.png')); ?>" alt="" />
  </div>
	
	<?php if(Session::has('message') OR $errors->any()): ?>
	<div class="modal fade" id="modal-message" tabindex="-1">
        <div class="modal-dialog modal-dialog-centered">
            <div class="modal-content">
                <div class="modal-header text-right ml-auto pr-0">
                    <button type="button" class="btn btn_brown rounded-circle" data-bs-dismiss="modal">
                        <i class="fas fa-times"></i>
                    </button>
                </div>
                <div class="modal-body">
                    <?php if($errors->any()): ?>
                        <?php echo $__env->make('include.alert', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                    <?php else: ?>
                        <?php echo e(Session::get('message')); ?>

                        <?php echo e(Session::forget('message')); ?>

                    <?php endif; ?>
                </div>
            </div>
        </div>
    </div>
    <?php endif; ?>
  
  <div class="page-wrapper">
    <?php echo $__env->make('layouts.front.header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

    <?php echo $__env->yieldContent('content'); ?>

    <?php echo $__env->make('layouts.front.footer', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
  </div>

	<div class="mobile-nav__wrapper" style="z-index: 100;">
    <div class="mobile-nav__overlay mobile-nav__toggler"></div>
    <!-- /.mobile-nav__overlay -->
    <div class="mobile-nav__content">
        <span class="mobile-nav__close mobile-nav__toggler"><i class="fa fa-times"></i></span>

        <div class="logo-box">
            <a href="index.html" aria-label="logo image"><img src="<?php echo e(asset('/images/resources/logo-2.png')); ?>" width="155"
                    alt="" /></a>
        </div>
        <!-- /.logo-box -->
        <div class="mobile-nav__container"></div>
        <!-- /.mobile-nav__container -->

        <ul class="mobile-nav__contact list-unstyled">
            <li>
                <i class="fa fa-envelope"></i>
                <a href="mailto:inquireqprohq@quantaservices.com">inquireqprohq@quantaservices.com</a>
            </li>
            <li>
                <i class="fa fa-phone-alt"></i>
                <a href="tel:+63286619398">+632 8661 9398 <br>
                                            +632 8661 9433</a>
            </li>
        </ul><!-- /.mobile-nav__contact -->

    </div>
    <!-- /.mobile-nav__content -->
  </div>
  <!-- /.mobile-nav__wrapper -->

  <div class="search-popup">
      <div class="search-popup__overlay search-toggler"></div>
      <!-- /.search-popup__overlay -->
      <div class="search-popup__content">
          <form action="#">
              <label for="search" class="sr-only">search here</label><!-- /.sr-only -->
              <input type="text" id="search" placeholder="Search Here..." />
              <button type="submit" aria-label="search submit" class="thm-btn">
                  <i class="icon-magnifying-glass"></i>
              </button>
          </form>
      </div>
      <!-- /.search-popup__content -->
  </div>
  <!-- /.search-popup -->

  <a href="#" data-target="html" class="scroll-to-target scroll-to-top"><i class="fa fa-angle-up"></i></a>

  <script src="<?php echo e(asset('/vendors/jquery/jquery-3.6.0.min.js')); ?>"></script>
  <script src="<?php echo e(asset('/vendors/bootstrap/js/bootstrap.bundle.min.js')); ?>"></script>
  <script src="<?php echo e(asset('/vendors/jarallax/jarallax.min.js')); ?>"></script>
  <script src="<?php echo e(asset('/vendors/jquery-ajaxchimp/jquery.ajaxchimp.min.js')); ?>"></script>
  <script src="<?php echo e(asset('/vendors/jquery-appear/jquery.appear.min.js')); ?>"></script>
  <script src="<?php echo e(asset('/vendors/jquery-circle-progress/jquery.circle-progress.min.js')); ?>"></script>
  <script src="<?php echo e(asset('/vendors/jquery-magnific-popup/jquery.magnific-popup.min.js')); ?>"></script>
  <script src="<?php echo e(asset('/vendors/jquery-validate/jquery.validate.min.js')); ?>"></script>
  <script src="<?php echo e(asset('/vendors/nouislider/nouislider.min.js')); ?>"></script>
  <script src="<?php echo e(asset('/vendors/odometer/odometer.min.js')); ?>"></script>
  <script src="<?php echo e(asset('/vendors/swiper/swiper.min.js')); ?>"></script>
  <script src="<?php echo e(asset('/vendors/tiny-slider/tiny-slider.min.js')); ?>"></script>
  <script src="<?php echo e(asset('/vendors/wnumb/wNumb.min.js')); ?>"></script>
  <script src="<?php echo e(asset('/vendors/wow/wow.js')); ?>"></script>
  <script src="<?php echo e(asset('/vendors/isotope/isotope.js')); ?>"></script>
  <script src="<?php echo e(asset('/vendors/countdown/countdown.min.js')); ?>"></script>
  <script src="<?php echo e(asset('/vendors/owl-carousel/owl.carousel.min.js')); ?>"></script>
  <script src="<?php echo e(asset('/vendors/twentytwenty/twentytwenty.js')); ?>"></script>
  <script src="<?php echo e(asset('/vendors/twentytwenty/jquery.event.move.js')); ?>"></script>
  <script src="<?php echo e(asset('/vendors/bxslider/jquery.bxslider.min.js')); ?>"></script>
  <script src="<?php echo e(asset('/vendors/bootstrap-select/js/bootstrap-select.min.js')); ?>"></script>
  <script src="<?php echo e(asset('/vendors/vegas/vegas.min.js')); ?>"></script>
  <script src="<?php echo e(asset('/vendors/jquery-ui/jquery-ui.js')); ?>"></script>
  <script src="<?php echo e(asset('/vendors/timepicker/timePicker.js')); ?>"></script>


  <script src="http://maps.google.com/maps/api/js?key=AIzaSyATY4Rxc8jNvDpsK8ZetC7JyN4PFVYGCGM"></script>


  <!-- template js -->
  <script src="<?php echo e(asset('/js/kontin.js')); ?>"></script>

	<?php if(Session::has('success')): ?>
    <div id="success" class="d-none"><?php echo e(Session::get('success')); ?></div> 
    <script>
      const Toast = Swal.mixin({
        toast: true,
        position: 'top-end',
        showConfirmButton: false,
        timer: 3000,
        timerProgressBar: true,
        didOpen: (toast) => {
          toast.addEventListener('mouseenter', Swal.stopTimer)
          toast.addEventListener('mouseleave', Swal.resumeTimer)
        }
      })

      Toast.fire({
        icon: 'success',
        title: document.getElementById('success').innerHTML
      })
    </script>
     <?php endif; ?>
     <?php if(Session::has('warning')): ?>
    <div id="warning" class="d-none"><?php echo e(Session::get('warning')); ?></div> 
     <script>
      const Toast = Swal.mixin({
        toast: true,
        position: 'top-end',
        showConfirmButton: false,
        timer: 3000,
        timerProgressBar: true,
        didOpen: (toast) => {
          toast.addEventListener('mouseenter', Swal.stopTimer)
          toast.addEventListener('mouseleave', Swal.resumeTimer)
        }
      })

      Toast.fire({
        icon: 'error',
        title: document.getElementById('warning').innerHTML
      })
    </script>
    <?php endif; ?>
	<script>
        $(window).on('load', function() {
            $('#modal-message').modal('show');
        });
    </script>

	<?php echo $__env->yieldContent('js'); ?>
</body>
</html>
<?php /**PATH /home/rweb/public_html/quantaservices/resources/views/layouts/front/app.blade.php ENDPATH**/ ?>