
<?php $__env->startSection('meta'); ?>
	<title>Careers | <?php echo e(env('APP_NAME')); ?></title>
    <meta name="description" content="Providing high-quality workforce and hosted services to Quanta Operating units" />

<?php $__env->stopSection(); ?>
<?php $__env->startSection('css'); ?>
<style>
</style>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
<div class="primary-content position-relative">
    <?php
        $careers = App\Models\Career::all();
        $careers_local = App\Models\Career::where('type', 'local')->get();
        $careers_international = App\Models\Career::where('type', 'international')->get();
    ?>
    <div class="d-none d-md-block fixed bg-light position-fixed my-5 wow fadeInLeft animated"  style="width: 25%; z-index: 3; visibility: visible; animation-duration: 1500ms; animation-delay: 0ms; animation-name: fadeInLeft;" data-wow-duration="1500ms" data-wow-delay="0ms">
        <div class="py-4 px-3 ps-lg-5" style="background: var(--thm-primary);">
            <h3 class="text-white ">Careers</h3>
        </div>

        <ul class="mx-3 mx-lg-5 widget__links-lis list-unstyled py-5">
            <li class="mb-3">
                <h5 class="">
                    <a class="border-bottom pb-1 link hover-primary" type="button" data-bs-toggle="collapse" data-bs-target="#local" aria-expanded="false" aria-controls="local" href="#"><img src="<?php echo e(asset('images/cross.png')); ?>" > Local</a>
                </h5>
                <div class="collapse" id="local">
                  <div class="card card-body bg-transparent border-0">
                    <ul class="widget__links-lis list-unstyled"> 
                        <?php if(!count($careers_local)): ?>
                        <li class="mb-3">
                            <h6>
                                <a class="border-bottom hover-primary pb-1 modal-btn">
                                    No available careers for local
                                </a>
                            </h6>
                        </li>
                        <?php endif; ?>
                        <?php $__currentLoopData = $careers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $career): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <?php if($career->type == 'Local'): ?>
                            <li class="mb-3">
                                <h6>
                                    <a class="border-bottom hover-primary pb-1 modal-btn" role="button" data-bs-toggle="modal" data-bs-target="#modal" href="#" data-content='<?php echo $career->content; ?>'>
                                        <img src="<?php echo e(asset('images/square.png')); ?>" > <?php echo e($career->title); ?>

                                    </a>
                                </h6>
                            </li>
                        <?php endif; ?>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </ul>
                  </div>
                </div>
            </li>
            <li class="mb-3">
                <h5 class="">
                    <a class="border-bottom pb-1 link hover-primary" type="button" data-bs-toggle="collapse" data-bs-target="#international" aria-expanded="false" aria-controls="international" href="#"><img src="<?php echo e(asset('images/cross.png')); ?>" > International</a>
                </h5>
                <div class="collapse" id="international">
                  <div class="card card-body bg-transparent border-0">
                    <ul class="widget__links-lis list-unstyled"> 
                        <?php $__currentLoopData = $careers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $career): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <?php if($career->type == 'International'): ?>
                            <li class="mb-3">
                                <h6>
                                    <a class="border-bottom hover-primary pb-1 modal-btn" role="button" data-bs-toggle="modal" data-bs-target="#modal" href="#" data-content='<?php echo $career->content; ?>'>
                                        <img src="<?php echo e(asset('images/square.png')); ?>" > <?php echo e($career->title); ?>

                                    </a>
                                </h6>
                            </li>
                        <?php endif; ?>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </ul>
                  </div>
                </div>
            </li>
        </ul>
    </div>

    <!--Page Header Start-->
    <section class="page-header" style="background-position:center; background-size: cover; background-image: url(<?php echo e(asset('/images/backgrounds/careers-banner.jpg')); ?>);">

        <div class="container">
            <div class="offset-md-3 page-header__inner">
                <h2 class="text-uppercase text-website-secondary">Careers</h2>
            </div>

        </div>
    </section>
    <!--Page Header End-->
    <!--Contact Page Start-->
    <section class="my-5">
        <div class="container">
            <div class="pt-5">
                <div class="row mb-5">
                    <div class="col offset-md-3 mb-5">
                        <div class="section-title">
                            <span class="section-title__tagline">Careers Local</span>
                        </div>
                        <div class="table-responsive">
                            <table class="table table-striped ">
                                <thead>
                                    <tr class="bg-danger text-white">
                                        <th width="50%">Title</th>
                                        <th width="25%">Department</th>
                                        <th width="25%">Location</th>
                                    </tr>
                                </thead>
                                <tbody class="text-black">
                                    <?php if(count($careers_local) == 0): ?>
                                        <tr>
                                            <td colspan="3">No available careers for local</td>
                                        </tr>
                                    <?php endif; ?>
                                    <?php $__currentLoopData = $careers_local; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $career): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <tr>
                                            <td scope="row">
                                                <a class="pb-1 modal-btn hover-primary" role="button" data-bs-toggle="modal" data-bs-target="#modal" href="#" 
                                                data-content='<?php echo $career->content; ?>'
                                                > <?php echo e($career->title); ?></a>
                                            </td>
                                            <td><?php echo e($career->department); ?></td>
                                            <td><?php echo e($career->location); ?></td>
                                        </tr>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
                <div class="row">
                    <div class="col offset-md-3 mb-5">
                        <div class="section-title">
                            <span class="section-title__tagline">Careers International</span>
                        </div>
                        <div class="table-responsive">
                            <table class="table table-striped ">
                                <thead>
                                    <tr class="bg-danger text-white">
                                        <th width="50%">Title</th>
                                        <th width="25%">Department</th>
                                        <th width="25%">Location</th>
                                    </tr>
                                </thead>
                                <tbody class="text-black">
                                    <?php if(count($careers_international) == 0): ?>
                                        <tr>
                                            <td colspan="3">No available careers for international</td>
                                        </tr>
                                    <?php endif; ?>
                                    <?php $__currentLoopData = $careers_international; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $career): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <tr>
                                            <td scope="row">
                                                <a class="pb-1 modal-btn hover-primary" role="button" data-bs-toggle="modal" data-bs-target="#modal" href="#" 
                                                data-content='<?php echo $career->content; ?>'
                                                > <?php echo e($career->title); ?></a>
                                            </td>
                                            <td><?php echo e($career->department); ?></td>
                                            <td><?php echo e($career->location); ?></td>
                                        </tr>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
                
            </div>
        </div>
    </section>
    </div>
</div>

<div class="modal fade" id="modal" tabindex="-1" aria-labelledby="modal" aria-hidden="true">
    <div class="modal-dialog modal-xl">
        <div class="modal-content rounded-0">
            <div class="modal-header border-0">
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
                <div id="content">

                </div>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('js'); ?>
<script>
    $('.modal-btn').click(function() {
        // alert()
        $("#content").html($(this).data("content"))
    });
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.front.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\Users\PC4\Desktop\leo dev\quanta\July 18 2022\resources\views/front/careers.blade.php ENDPATH**/ ?>