<?php

use App\Exports\ApplicantsExport;
use Maatwebsite\Excel\Facades\Excel;
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\StripeController;
use App\Http\Controllers\SubscriptionController;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/

// Route::get('/home', [App\Http\Controllers\Front\PageController::class, 'home'])->name('home');
Route::get('/', [App\Http\Controllers\Front\PageController::class, 'home'])->name('home');
Route::prefix('our-company')->group(function () {
    Route::get('about-quanta', [App\Http\Controllers\Front\PageController::class, 'aboutQuanta'])->name('our-company.aboutQuanta');
    Route::get('history', [App\Http\Controllers\Front\PageController::class, 'historyQuanta'])->name('our-company.historyQuanta');
    Route::get('vision-mission', [App\Http\Controllers\Front\PageController::class, 'visionMissionQuanta'])->name('our-company.visionMissionQuanta');
    Route::get('leadership', [App\Http\Controllers\Front\PageController::class, 'leadershipQuanta'])->name('our-company.leadershipQuanta');
    Route::get('making-difference', [App\Http\Controllers\Front\PageController::class, 'makingDifferenceQuanta'])->name('our-company.makingDifferenceQuanta');
});
Route::prefix('services')->group(function () {
    Route::get('engineering-design-and-drafting-service', [App\Http\Controllers\Front\PageController::class, 'edds'])->name('services.edds');
    Route::get('information-technology', [App\Http\Controllers\Front\PageController::class, 'it'])->name('services.it');
    Route::get('others', [App\Http\Controllers\Front\PageController::class, 'others'])->name('services.others');
});
Route::get('careers', [App\Http\Controllers\Front\PageController::class, 'careers'])->name('careers');
Route::get('clients', [App\Http\Controllers\Front\PageController::class, 'clients'])->name('clients');
Route::get('contact', [App\Http\Controllers\Front\PageController::class, 'contact'])->name('contact');
Route::get('news-details', [App\Http\Controllers\Front\PageController::class, 'newsDetails'])->name('newsDetails');
Route::get('news', [App\Http\Controllers\Front\PageController::class, 'news'])->name('news');
// Route::get('project-details', [App\Http\Controllers\Front\PageController::class, 'projectDetails'])->name('projectDetails');
Route::get('projects', [App\Http\Controllers\Front\PageController::class, 'project'])->name('project');
Route::get('resources', [App\Http\Controllers\Front\PageController::class, 'resources'])->name('resources');
// Route::get('services', [App\Http\Controllers\Front\PageController::class, 'services'])->name('services');
Route::post('applicants/store_applicant', [App\Http\Controllers\ApplicantsController::class, 'store'])->name('store.applicants');


// Post Form
Route::prefix('send')->group(function () {
    Route::post('contact', [App\Http\Controllers\Admin\Page\ContactController::class, 'store'])->name('send.contact');
    Route::post('subscribe', [App\Http\Controllers\Admin\Page\SubscribeController::class, 'store'])->name('send.subscribe');
});

Auth::routes(['register' => false, 'login' => false, 'reset' => false]);




Route::prefix('admin')->group(function () {
    Route::get('/applicants/export', function () {
        return Excel::download(new ApplicantsExport, 'applicants.xlsx');
    })->name('applicants.export');


    Route::get('/login', [App\Http\Controllers\Admin\UserController::class, 'login'])->name('login');
    // Route::get('/dashboard', [App\Http\Controllers\HomeController::class, 'index'])->name('dashboard');
    Route::post('/login', [App\Http\Controllers\Admin\UserController::class, 'signin'])->name('login');

    Route::middleware(['auth.cms', 'auth'])->group(function () {
        // CMS
        Route::post('/logout', [App\Http\Controllers\Admin\UserController::class, 'logout'])->name('logout');

        Route::resource('contact', App\Http\Controllers\Admin\Page\ContactController::class);
        Route::resource('careers', App\Http\Controllers\Admin\Page\CareerController::class);
        Route::resource('clients', App\Http\Controllers\Admin\Page\ClientController::class);
        Route::resource('projects', App\Http\Controllers\Admin\Page\ProjectController::class);
        Route::resource('applicants', App\Http\Controllers\ApplicantsController::class);

        // Route::resource('blogs', App\Http\Controllers\Admin\Page\Blogs\BlogController::class);
        // Route::resource('testimonials', App\Http\Controllers\Admin\Page\TestimonialController::class);
        // Route::resource('products', App\Http\Controllers\Admin\Page\ProductController::class);
        // Route::resource('orders', App\Http\Controllers\Admin\Page\OrderController::class);
        // Users Auth;
        Route::get('dashboard', [App\Http\Controllers\Admin\PageController::class, 'dashboard'])->name('dashboard');
        Route::resource('Users', App\Http\Controllers\Admin\UserController::class);
        Route::post('Account/activation/{id}', [App\Http\Controllers\Admin\PageController::class, 'activation']);
        Route::get('Profile', [App\Http\Controllers\Admin\PageController::class, 'profile'])->name('profile');
        Route::get('reset-password/{id}', [App\Http\Controllers\Admin\PageController::class, 'reset'])->name('password_reset');
        Route::put('update-password/{id}', [App\Http\Controllers\Admin\PageController::class, 'update_password'])->name('password_update');
        Route::put('update-profile/{id}', [App\Http\Controllers\Admin\PageController::class, 'update_profile'])->name('profile.update');
    });
});

Route::prefix('user')->group(function () {
    Route::get('/login', [App\Http\Controllers\Front\UserController::class, 'login'])->name('page.login');
    Route::post('/login', [App\Http\Controllers\Front\UserController::class, 'signin'])->name('page.signin');
    Route::get('/register', [App\Http\Controllers\Front\UserController::class, 'register'])->name('page.register');
    Route::post('/register', [App\Http\Controllers\Front\UserController::class, 'signup'])->name('page.signup');

    Route::middleware(['auth.user', 'auth'])->group(function () {
        // Users Auth;
        Route::post('/logout', [App\Http\Controllers\Front\UserController::class, 'logout'])->name('page.logout');
        // Route::post('Account/activation/{id}', [App\Http\Controllers\User\UserController::class, 'activation']);
        Route::get('dashboard', [App\Http\Controllers\Front\PageController::class, 'dashboard'])->name('dashboard');
        // Route::get('Users/reset/{id}', [App\Http\Controllers\User\UserController::class, 'reset'])->name('password_reset');
        Route::put('/password/{id}', [App\Http\Controllers\User\UserController::class, 'update_password'])->name('password_update');
        Route::put('/profile/{id}', [App\Http\Controllers\User\UserController::class, 'update_profile'])->name('profile.update');
    });
});

// // paypal
// Route::get('paywithpaypal', [App\Http\Controllers\PaypalController::class, 'payWithPaypal'])->name('paywithpaypal');
// Route::post('paypal', [App\Http\Controllers\PaypalController::class, 'postPaymentWithpaypal'])->name('paypal');
// Route::get('paypal', [App\Http\Controllers\PaypalController::class, 'getPaymentStatus'])->name('status');

// // stripes
// Route::post('stripe-checkout', [App\Http\Controllers\StripeController::class, 'stripeCheckout'])->name('stripe.stripeCheckout');
// Route::get('stripe-success', [App\Http\Controllers\StripeController::class, 'stripeSuccess'])->name('stripe.stripeSuccess');
// Route::get('stripe-cancel', [App\Http\Controllers\StripeController::class, 'stripeCancel'])->name('stripe.stripeCancel');
// Route::stripeWebhooks('stripe-webhook');
