@extends('layouts.admin.app')

@section('content')
	<div class="modal fade text-left" id="deleteModal" tabindex="-1" role="dialog" aria-labelledby="myModalLabel120" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered modal-dialog-scrollable" role="document">
            <div class="modal-content">
                <div class="modal-header bg-danger white">
                    <h5 class="modal-title" id="myModalLabel120">Delete Data</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    Are you sure you want to delete this data?
                </div>
                <div class="modal-footer">
                    <form method="post" action="{{ url('delete/1') }}" class="btn-ok"> @csrf @method('delete')
                    	<button type="submit" class="btn btn-danger">
                    	  	Yes
                    	</button>
                  	</form>
					<button type="button" class="btn btn-primary" data-dismiss="modal">No</button>
                </div>
            </div>
        </div>
    </div>
	<div class="app-content content" id="table-hover-animation">
        <div class="content-overlay"></div>
        <div class="header-navbar-shadow"></div>
        <div class="content-wrapper">
            <div class="content-header row">
                <div class="content-header-left col-md-9 col-12 mb-2">
                    <div class="row breadcrumbs">
                        <div class="col-12">
                            <h2 class="content-header-title float-left mb-0">List View</h2>
                            <div class="breadcrumb-wrapper col-12">
                                <ol class="breadcrumb">
                                    <li class="breadcrumb-item">
                                    	<a href="{{ url('home') }}">Home</a>
                                    </li>
                                    {{-- <li class="breadcrumb-item">
                                    	<a href="#">Data List</a>
                                    </li> --}}
                                    <li class="breadcrumb-item active">
                                    	Orders
                                    </li>
                                </ol>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            @include('include.alert')
            
            <div class="content-body">
                <!-- Data list view starts -->
                <section id="data-list-view" class="data-list-view-header">
                    
                    <!-- DataTable starts -->
                    <div class="table-responsive">
                        <table class="table table-striped zero-configuration {{-- dataex-html5-selectors --}} table-hover-animation">
                            <thead>
                                <tr>
                                    {{-- <th></th> --}}
                                    <th>ID</th>
                                    <th>FULLNAME</th>
                                    <th>EMAIL</th>
                                    <th>PAYMENT METHOD</th>
                                    <th>PAYMENT STATUS</th>
                                    <th>STATUS</th>
                                    <th>TOTAL</th>
                                    <!-- <th>SUBJECT</th> -->
                                    <th>ACTION</th>
                                </tr>
                            </thead>
                            <tbody>
                            	@foreach($data as $value)
                                <tr class="text-center">
                                	{{-- <td>{{ $count++ }}</td> --}}
                                	<td>{{ $value->id }}</td>
                                	<td>{{ $value->bill_name }}</td>
                                    <td>{{ $value->bill_email }}</td>
                                    <td>{{ $value->payment_method }}</td>
                                    <td>{{ $value->payment_status }}</td>
                                    <td>{{ $value->status }}</td>
                                    <td>{{ $value->total_amount_due }}</td>
                                    {{-- <td>
                                        {{ ucfirst($value->bill_subject) }}
                                    </td> --}}
                                	<td>
                                        @if(Auth::user()->role != 'viewer')
                                		<a class="" href="#" data-toggle="modal" data-target="#info{{ $value->id }}">
                                            Details
                                		</a>
                                        |
                                		<a class="delte text-danger" href="#" data-href="{{ url('admin/orders/'.$value->id) }}" id="deletecart">
                                			{{-- <i data-feather="trash"></i> --}}
                                            Delete
					                	</a>
                                        @else 
                                        <small class="font-italic">No Action</small>
                                        @endif
                                	</td>
                                </tr>
                                @endforeach
                            </tbody>
                        </table>
                    </div>
                </section>
            </div>
        </div>
    </div>
	@foreach($data as $value)
    @include('module.order.info')
    @endforeach
@stop
@section('js')
    <script src="//cdn.ckeditor.com/4.13.0/standard/ckeditor.js"></script>
    {{-- <script src="{{ asset('js/filereader.min.js') }}"></script> --}}
	<script type="text/javascript">
        $('.delte').click(function () {
			var id = $(this).data('href');
			$('.btn-ok').attr('action', id);
			$('#deleteModal').modal('show');
		});
	</script>
@stop