@extends('layouts.front.app')
@section('meta')
	<title>Projects | {{ env('APP_NAME') }}</title>
    <meta name="description" content="Providing high-quality workforce and hosted services to Quanta Operating units" />

@stop
@section('css')
<style>
</style>
@endsection
@section('content')
<div class="primary-content position-relative">
            
    <div class="d-none d-md-block fixed bg-light position-fixed my-5 wow fadeInLeft animated"  style="width: 25%; z-index: 4; visibility: visible; animation-duration: 1500ms; animation-delay: 0ms; animation-name: fadeInLeft;" data-wow-duration="1500ms" data-wow-delay="0ms">
        <div class="py-4 px-3 ps-lg-5" style="background: var(--thm-primary);">
            <h3 class="text-white ">Projects</h3>
        </div>
        <ul class="mx-3 mx-lg-5 widget__links-lis list-unstyled py-5">
            <li class="mb-3">
                <h5 class="">
                    <a class="border-bottom pb-1 link hover-primary" type="button" data-bs-toggle="collapse" data-bs-target="#ongoingCollapse" aria-expanded="false" aria-controls="ongoingCollapse" href="#"><img src="{{asset('images/cross.png')}}" > On-Going Projects</a>
                </h5>
                <div class="collapse" id="ongoingCollapse">
                  <div class="card card-body bg-transparent border-0">
                    <ul class="widget__links-lis list-unstyled"> 
                        @foreach ($clients as $client)
                            @foreach ($ongoings as $client_id => $ongoing)
                                @if ($client_id == $client->id && count($ongoing) != 0)
                                    <li class="mb-3"> <h6>
                                        <a class="border-bottom pb-1 modal-btn" role="button" data-bs-toggle="modal" data-bs-target="#modal"
                                        data-content='
                                        <section class="project-full-width pt-0">
                                            <div class="container">
                                                <div class="text-end">
                                                    <img class="img-fluid" src="{{asset('/uploads/clients/'.$client->logo)}}" alt="" style="width: 100px">
                                                </div>
                                                <div class="section-title text-center  mb-md-5">
                                                    <h2 class="section-title__title text-start mb-md-5 text-center">Projects Details</h2>
                                                </div>
                                                
                                                @foreach ($ongoing  as $project)

                                                    @if (!$project->status && $project->client_id == $client->id)
                                                    <div class="row my-5">
                                                        <div class="col-xl-8">
                                                            <div class="">
                                                                <h3 class="project-full-width__title">{{$project->title}}</h3>
                                                                {!!$project->content!!}
                                                            </div>
                                                        </div>
                                                        <div class="col-xl-4">
                                                            <div class="project-full-width__details-info border p-4" style="border-bottom: 5px solid var(--thm-primary) !important">
                                                                @if ($project->operating_unit)
                                                                <div class="project-full-width__details-info-single">
                                                                    <h5 class="project-full-width__details-info-client">Operating Unit:</h5>
                                                                    <p class="project-full-width__details-info-name">{{$project->operating_unit}}</p>
                                                                </div>
                                                                @endif
                                                                @if ($project->area)
                                                                <div class="project-full-width__details-info-single">
                                                                    <h5 class="project-full-width__details-info-client">Project:</h5>
                                                                    <p class="project-full-width__details-info-name">{{$project->project}}</p>
                                                                </div>
                                                                @endif
                                                                @if ($project->project)
                                                                <div class="project-full-width__details-info-single">
                                                                    <h5 class="project-full-width__details-info-client">Area:</h5>
                                                                    <p class="project-full-width__details-info-name">{{$project->area}}</p>
                                                                </div>
                                                                @endif
                                                                @if ($project->projworkect)
                                                                <div class="project-full-width__details-info-single">
                                                                    <h5 class="project-full-width__details-info-client">Work:</h5>
                                                                    <p class="project-full-width__details-info-name">{{$project->work}}</p>
                                                                </div>
                                                                @endif
                                                                @if ($project->division)
                                                                <div class="project-full-width__details-info-single">
                                                                    <h5 class="project-full-width__details-info-client">Division:</h5>
                                                                    <p class="project-full-width__details-info-name">{{$project->division}}</p>
                                                                </div>
                                                                @endif
                                                                {{-- @if ($project->man_hours)
                                                                <div class="project-full-width__details-info-single">
                                                                    <h5 class="project-full-width__details-info-client">Actual Man-hours:</h5>
                                                                    <p class="project-full-width__details-info-name">{{$project->man_hours}}</p>
                                                                </div>
                                                                @endif --}}
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <hr>
                                                    @endif
                                                @endforeach
                            
                                                </div>
                                            </section>
                                        '>
                                        <img src="{{asset('images/square.png')}}" > {{$client->name}} </a> </h6></li>
                                @endif
                            @endforeach
                        @endforeach
                    </ul>
                  </div>
                </div>
            </li>
            <li class="mb-3">
                <h5 class="">
                    <a class="border-bottom pb-1 link hover-primary" type="button" data-bs-toggle="collapse" data-bs-target="#completedCollapse" aria-expanded="false" aria-controls="completedCollapse" href="#"><img src="{{asset('images/cross.png')}}" > Completed Projects</a>
                </h5>
                <div class="collapse" id="completedCollapse">
                  <div class="card card-body bg-transparent border-0">
                    <ul class="widget__links-lis list-unstyled"> 
                        @foreach ($clients as $client)
                            @foreach ($completes as $client_id => $complete)
                                @if ($client_id == $client->id && count($complete) != 0)
                                    <li class="mb-3"> <h6>
                                        <a class="border-bottom pb-1 modal-btn" role="button" data-bs-toggle="modal" data-bs-target="#modal"
                                        data-content='
                                        <section class="project-full-width pt-0">
                                            <div class="container">
                                                <div class="text-end">
                                                    <img class="img-fluid" src="{{asset('/uploads/clients/'.$client->logo)}}" alt="" style="width: 100px">
                                                </div>
                                                <div class="section-title text-center  mb-md-5">
                                                    <h2 class="section-title__title text-start mb-md-5 text-center">Projects Details</h2>
                                                </div>
                                                
                                                @foreach ($complete  as $project)
                                                
                                                    @if ($project->status && $project->client_id == $client->id)
                                                    <div class="row my-5">
                                                        <div class="col-xl-8">
                                                            <div class="">
                                                                <h3 class="project-full-width__title">{{$project->title}}</h3>
                                                                {!!$project->content!!}
                                                            </div>
                                                        </div>
                                                        <div class="col-xl-4">
                                                            <div class="project-full-width__details-info border p-4" style="border-bottom: 5px solid var(--thm-primary) !important">
                                                                @if ($project->operating_unit)
                                                                <div class="project-full-width__details-info-single">
                                                                    <h5 class="project-full-width__details-info-client">Operating Unit:</h5>
                                                                    <p class="project-full-width__details-info-name">{{$project->operating_unit}}</p>
                                                                </div>
                                                                @endif
                                                                @if ($project->area)
                                                                <div class="project-full-width__details-info-single">
                                                                    <h5 class="project-full-width__details-info-client">Project:</h5>
                                                                    <p class="project-full-width__details-info-name">{{$project->project}}</p>
                                                                </div>
                                                                @endif
                                                                @if ($project->project)
                                                                <div class="project-full-width__details-info-single">
                                                                    <h5 class="project-full-width__details-info-client">Area:</h5>
                                                                    <p class="project-full-width__details-info-name">{{$project->area}}</p>
                                                                </div>
                                                                @endif
                                                                @if ($project->projworkect)
                                                                <div class="project-full-width__details-info-single">
                                                                    <h5 class="project-full-width__details-info-client">Work:</h5>
                                                                    <p class="project-full-width__details-info-name">{{$project->work}}</p>
                                                                </div>
                                                                @endif
                                                                @if ($project->division)
                                                                <div class="project-full-width__details-info-single">
                                                                    <h5 class="project-full-width__details-info-client">Division:</h5>
                                                                    <p class="project-full-width__details-info-name">{{$project->division}}</p>
                                                                </div>
                                                                @endif
                                                                {{-- @if ($project->man_hours)
                                                                <div class="project-full-width__details-info-single">
                                                                    <h5 class="project-full-width__details-info-client">Actual Man-hours:</h5>
                                                                    <p class="project-full-width__details-info-name">{{$project->man_hours}}</p>
                                                                </div>
                                                                @endif --}}
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <hr>
                                                    @endif
                                                @endforeach
                            
                                                </div>
                                            </section>
                                        '>
                                        <img src="{{asset('images/square.png')}}" > {{$client->name}} </a> </h6></li>
                                @endif
                            @endforeach
                        @endforeach
                        {{-- <li class="mb-3"> <h6><a class="border-bottom pb-1" href="#" role="button" data-bs-toggle="modal" data-bs-target="#qtsCompletedModal"><img src="{{asset('images/square.png')}}" > Quanta Telecom Services </a> </h6></li>
                        <li class="mb-3"> <h6><a class="border-bottom pb-1" href="#" role="button" data-bs-toggle="modal" data-bs-target="#npcModal"><img src="{{asset('images/square.png')}}" > Northern Powerline Constructors, Inc. </a> </h6></li>
                        <li class="mb-3"> <h6><a class="border-bottom pb-1" href="#" role="button" data-bs-toggle="modal" data-bs-target="#valardModal"><img src="{{asset('images/square.png')}}" > Valard Telecommunications </a> </h6></li>
                        <li class="mb-3"> <h6><a class="border-bottom pb-1" href="#" role="button" data-bs-toggle="modal" data-bs-target="#drModal"><img src="{{asset('images/square.png')}}" > Dashiell-Raleigh </a> </h6></li>
                        <li class="mb-3"> <h6><a class="border-bottom pb-1" href="#" role="button" data-bs-toggle="modal" data-bs-target="#qpseModal"><img src="{{asset('images/square.png')}}" > Quanta Pipeline and Services Engineering </a> </h6> </li>
                        <li class="mb-3"> <h6><a class="border-bottom pb-1" href="#" role="button" data-bs-toggle="modal" data-bs-target="#uccModal"><img src="{{asset('images/square.png')}}" > Underground Construction Company </a> </h6> </li>
                        <li class="mb-3"> <h6><a class="border-bottom pb-1" href="#" role="button" data-bs-toggle="modal" data-bs-target="#pesModal"><img src="{{asset('images/square.png')}}" > Performance Engineering Services </a> </h6> </li>
                     --}}
                    </ul>
                  </div>
                </div>
            </li>
        </ul>
    </div>

    <!--Page Header Start-->
    <section class="page-header" style="background-position:center; background-size: cover; background-image: url({{asset('/images/backgrounds/projects-banner.jpg')}});">

        <div class="container">
            <div class="offset-md-3 page-header__inner">
                {{-- <ul class="thm-breadcrumb list-unstyled">
                    <li><a href="index.html">Home</a></li>
                    <li><span>/</span></li>
                    <li>Project</li>
                </ul> --}}
                <h2 class="text-uppercase text-website-secondary">Project</h2>
            </div>
        </div>
    </section>
    <!--Page Header End-->

    <!--Project Two Start-->
    <div id="ongoing"></div>
    <section class="project-two project-page">
        <div class="container">
            <div class="row">
                <div class="col offset-md-3">
                    <div class="section-title text-center">
                        <span class="section-title__tagline mb-4">Projects</span>
                        <h2 class="section-title__title text-start mb-5 text-center">On-going Projects</h2>
                    </div>
                    <div id="completed"></div>

                    <div class="row">
                       @foreach ($clients as $client)
                            @foreach ($ongoings as $client_id => $ongoing)
                                @if ($client_id == $client->id && count($ongoing) != 0)
                                    <div class="col-xl-3 col-md-3 col-sm-4 col-6 wow fadeInLeft" data-wow-duration="1500ms" data-wow-delay="0ms">
                                        <div class="news-one__single text-center">
                                            <a class="modal-btn" role="button" data-bs-toggle="modal" data-bs-target="#modal"
                                                data-content='
                                                
                                                <section class="project-full-width pt-0">
                                                    <div class="container">
                                                        <div class="text-end">
                                                            <img class="img-fluid" src="{{asset('/uploads/clients/'.$client->logo)}}" alt="" style="width: 100px">
                                                        </div>
                                                        <div class="section-title text-center  mb-md-5">
                                                            <h2 class="section-title__title text-start mb-md-5 text-center">Projects Details</h2>
                                                        </div>
                                                        
                                                        @foreach ($ongoing  as $project)

                                                            @if (!$project->status && $project->client_id == $client->id)
                                                            <div class="row my-5">
                                                                <div class="col-xl-8">
                                                                    <div class="">
                                                                        <h3 class="project-full-width__title">{{$project->title}}</h3>
                                                                        {!!$project->content!!}
                                                                    </div>
                                                                </div>
                                                                <div class="col-xl-4">
                                                                    <div class="project-full-width__details-info border p-4" style="border-bottom: 5px solid var(--thm-primary) !important">
                                                                        @if ($project->operating_unit)
                                                                        <div class="project-full-width__details-info-single">
                                                                            <h5 class="project-full-width__details-info-client">Operating Unit:</h5>
                                                                            <p class="project-full-width__details-info-name">{{$project->operating_unit}}</p>
                                                                        </div>
                                                                        @endif
                                                                        @if ($project->area)
                                                                        <div class="project-full-width__details-info-single">
                                                                            <h5 class="project-full-width__details-info-client">Project:</h5>
                                                                            <p class="project-full-width__details-info-name">{{$project->project}}</p>
                                                                        </div>
                                                                        @endif
                                                                        @if ($project->project)
                                                                        <div class="project-full-width__details-info-single">
                                                                            <h5 class="project-full-width__details-info-client">Area:</h5>
                                                                            <p class="project-full-width__details-info-name">{{$project->area}}</p>
                                                                        </div>
                                                                        @endif
                                                                        @if ($project->projworkect)
                                                                        <div class="project-full-width__details-info-single">
                                                                            <h5 class="project-full-width__details-info-client">Work:</h5>
                                                                            <p class="project-full-width__details-info-name">{{$project->work}}</p>
                                                                        </div>
                                                                        @endif
                                                                        @if ($project->division)
                                                                        <div class="project-full-width__details-info-single">
                                                                            <h5 class="project-full-width__details-info-client">Division:</h5>
                                                                            <p class="project-full-width__details-info-name">{{$project->division}}</p>
                                                                        </div>
                                                                        @endif
                                                                        {{-- @if ($project->man_hours)
                                                                        <div class="project-full-width__details-info-single">
                                                                            <h5 class="project-full-width__details-info-client">Actual Man-hours:</h5>
                                                                            <p class="project-full-width__details-info-name">{{$project->man_hours}}</p>
                                                                        </div>
                                                                        @endif --}}
                                                                    </div>
                                                                </div>
                                                            </div>
                                                            <hr>
                                                            @endif
                                                        @endforeach
                                    
                                                        </div>
                                                    </section>
                                                '>

                                                <div class="news-one__content border">
                                                    <img class="img-fluid" src="{{asset('/uploads/clients/'.$client->logo)}}" alt="">
                                                </div>
                                            </a>
                                            <p class="text-dark">
                                                {{$client->name}}
                                            </p>
                                        </div>
                                    </div>
                                @endif
                            @endforeach
                       @endforeach
                    </div>

                    <div class="section-title text-center mt-5">
                        <h2 class="section-title__title text-start mb-5 text-center">Completed Projects</h2>
                    </div>
                    <div class="row mb-5">
                        @foreach ($clients as $client)
                            @foreach ($completes as $client_id => $complete)
                                @if ($client_id == $client->id && count($complete) != 0)
                                    <div class="col-xl-3 col-md-3 col-sm-4 col-6 wow fadeInLeft" data-wow-duration="1500ms" data-wow-delay="0ms">
                                        <div class="news-one__single text-center">
                                            <a class="modal-btn" role="button" data-bs-toggle="modal" data-bs-target="#modal"
                                                data-content='
                                                
                                                <section class="project-full-width pt-0">
                                                    <div class="container">
                                                        <div class="text-end">
                                                            <img class="img-fluid" src="{{asset('/uploads/clients/'.$client->logo)}}" alt="" style="width: 100px">
                                                        </div>
                                                        <div class="section-title text-center  mb-md-5">
                                                            <h2 class="section-title__title text-start mb-md-5 text-center">Projects Details</h2>
                                                        </div>
                                                        
                                                        @foreach ($complete  as $project)
                                                            @if ($project->status && $project->client_id == $client->id)
                                                            {{-- @php
                                                                print_r($project);
                                                            @endphp --}}
                                                            <div class="row my-5">
                                                                <div class="col-xl-8">
                                                                    <div class="">
                                                                        <h3 class="project-full-width__title">{{$project->title}}</h3>
                                                                        {!!$project->content!!}
                                                                    </div>
                                                                </div>
                                                                <div class="col-xl-4">
                                                                    <div class="project-full-width__details-info border p-4" style="border-bottom: 5px solid var(--thm-primary) !important">
                                                                        @if ($project->operating_unit)
                                                                        <div class="project-full-width__details-info-single">
                                                                            <h5 class="project-full-width__details-info-client">Operating Unit:</h5>
                                                                            <p class="project-full-width__details-info-name">{{$project->operating_unit}}</p>
                                                                        </div>
                                                                        @endif
                                                                        @if ($project->area)
                                                                        <div class="project-full-width__details-info-single">
                                                                            <h5 class="project-full-width__details-info-client">Project:</h5>
                                                                            <p class="project-full-width__details-info-name">{{$project->project}}</p>
                                                                        </div>
                                                                        @endif
                                                                        @if ($project->project)
                                                                        <div class="project-full-width__details-info-single">
                                                                            <h5 class="project-full-width__details-info-client">Area:</h5>
                                                                            <p class="project-full-width__details-info-name">{{$project->area}}</p>
                                                                        </div>
                                                                        @endif
                                                                        @if ($project->projworkect)
                                                                        <div class="project-full-width__details-info-single">
                                                                            <h5 class="project-full-width__details-info-client">Work:</h5>
                                                                            <p class="project-full-width__details-info-name">{{$project->work}}</p>
                                                                        </div>
                                                                        @endif
                                                                        @if ($project->division)
                                                                        <div class="project-full-width__details-info-single">
                                                                            <h5 class="project-full-width__details-info-client">Division:</h5>
                                                                            <p class="project-full-width__details-info-name">{{$project->division}}</p>
                                                                        </div>
                                                                        @endif
                                                                        {{-- @if ($project->man_hours)
                                                                        <div class="project-full-width__details-info-single">
                                                                            <h5 class="project-full-width__details-info-client">Actual Man-hours:</h5>
                                                                            <p class="project-full-width__details-info-name">{{$project->man_hours}}</p>
                                                                        </div>
                                                                        @endif --}}
                                                                    </div>
                                                                </div>
                                                            </div>
                                                            <hr>
                                                            @endif
                                                        @endforeach

                                    
                                                        </div>
                                                    </section>
                                                '>

                                                <div class="news-one__content border">
                                                    <img class="img-fluid" src="{{asset('/uploads/clients/'.$client->logo)}}" alt="">
                                                </div>
                                            </a>
                                            <p class="text-dark">
                                                {{$client->name}}
                                            </p>
                                        </div>
                                    </div>
                                @endif
                            @endforeach
                       @endforeach
                    </div>

                    
                </div>
            </div>
        </div>
    </section>

</div>

<div class="modal fade" id="modal" tabindex="-1" aria-labelledby="modal" aria-hidden="true">
    <div class="modal-dialog modal-xl">
        <div class="modal-content rounded-0">
            <div class="modal-header border-0">
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
                <div id="content">

                </div>
            </div>
        </div>
    </div>
</div>

<!--  project1 ongoing modal -->
<div class="modal fade" id="qtsOnGoingModal" tabindex="-1" aria-labelledby="qtsOnGoingModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-xl">
        <div class="modal-content rounded-0">
            <div class="modal-header border-0">
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
                
                <section class="project-full-width pt-0">
                    <div class="container">
                        <div class="text-end">
                            <img class="img-fluid" src="{{asset('/images/brand/brand-1-55.png')}}" alt="">
                        </div>
                        <div class="section-title text-center  mb-md-5">
                            <h2 class="section-title__title text-start mb-md-5 text-center">Projects Details</h2>
                        </div>
                        
                        <div class="row mb-5">
                            <div class="col-xl-8">
                                <div class="">
                                    <h3 class="project-full-width__title">Trident / POSPac Operation</h3>
                                    <h5 class="project-full-width__details-info-client">Deliverables:</h5>
                                    <p class="project-full-width__text-1">Currently working on the Garden City (covering 74 miles) and Boise City (covering 180 miles) for address verification.</p>
                                    <p class="project-full-width__text-1">Structure points for GPS, and FOC, DW, SW determination using point
                                        clouds captured by the MX2 mobile.</p>
                                </div>
                            </div>
                            <div class="col-xl-4">
                                <div class="project-full-width__details-info border p-4" style="border-bottom: 5px solid var(--thm-primary) !important">
                                    <div class="project-full-width__details-info-single">
                                        <h5 class="project-full-width__details-info-client">Operating Unit:</h5>
                                        <p class="project-full-width__details-info-name">Quanta Telecommunication Services</p>
                                    </div>
                                    <div class="project-full-width__details-info-single">
                                        <h5 class="project-full-width__details-info-client">Work:</h5>
                                        <p class="project-full-width__details-info-name">Trident / POSPac Operation</p>
                                    </div>
                                    <div class="project-full-width__details-info-single">
                                        <h5 class="project-full-width__details-info-client">Division:</h5>
                                        <p class="project-full-width__details-info-name">QTS, Div. 11, Arizona Office</p>
                                    </div>
                                    <div class="project-full-width__details-info-single">
                                        <h5 class="project-full-width__details-info-client">Actual Man-hours:</h5>
                                        <p class="project-full-width__details-info-name">On-going</p>
                                    </div>
                                </div>
                            </div>
                        </div>

                    </div>
                </section>

            </div>
        </div>
    </div>
</div>

<!-- project1 completed modal -->
<div class="modal fade" id="qtsCompletedModal" tabindex="-1" aria-labelledby="qtsCompletedModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-xl">
        <div class="modal-content rounded-0">
            <div class="modal-header border-0">
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
                
                <section class="project-full-width pt-0">
                    <div class="container">
                        <div class="text-end">
                            <img class="img-fluid" src="{{asset('/images/brand/brand-1-55.png')}}" alt="">
                        </div>
                        <div class="section-title text-center  mb-md-5">
                            <h2 class="section-title__title text-start mb-md-5 text-center">Projects Details</h2>
                        </div>
                        <!-- 1 -->
                        <div class="row mb-5">
                            <div class="col-xl-8">
                                <div class="">
                                    <h3 class="project-full-width__title">Trident / POSPac Operation</h3>
                                    <h5 class="project-full-width__details-info-client">Deliverables:</h5>
                                    <p class="project-full-width__text-1"> Operated 286-mile road using POSPac and Trident software thru MX2equipment.</p>
                                    <p class="project-full-width__text-1">Worked on 31 missions with 215 runs across Atlanta area to be used for
                                        exporting shape and drawing files needed in permitting works.</p>
                                    <p class="project-full-width__text-1"> Reducing site workers for manually capturing data in the field.</p>
                                </div>
                            </div>
                            <div class="col-xl-4">
                                <div class="project-full-width__details-info border p-4" style="border-bottom: 5px solid var(--thm-primary) !important">
                                    <div class="project-full-width__details-info-single">
                                        <h5 class="project-full-width__details-info-client">Work:</h5>
                                        <p class="project-full-width__details-info-name">Trident / POSPac Operation</p>
                                    </div>
                                    <div class="project-full-width__details-info-single">
                                        <h5 class="project-full-width__details-info-client">Division:</h5>
                                        <p class="project-full-width__details-info-name">QTS, Div. 10, Atlanta Office</p>
                                    </div>
                                    <div class="project-full-width__details-info-single">
                                        <h5 class="project-full-width__details-info-client">Actual Man-hours:</h5>
                                        <p class="project-full-width__details-info-name">8,009 man-hours</p>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <!-- 2 -->
                        <div class="row mb-5">
                            <div class="col-xl-8">
                                <div class="">
                                    <h3 class="project-full-width__title">Atlanta</h3>
                                    <h5 class="project-full-width__details-info-client">Deliverables:</h5>
                                    <p class="project-full-width__text-1"> Completed  base  map  drawing  including  roads,  street  names,  curb  &  gutters, driveways, sidewalks and dimensions for the following area:
                                    </p>
                                    <ul>
                                        <li>Columbia – 111 miles covered</li>
                                        <li>Shakespeare – 145 miles covered </li>
                                    </ul>
                                </div>
                            </div>
                            <div class="col-xl-4">
                                <div class="project-full-width__details-info border p-4" style="border-bottom: 5px solid var(--thm-primary) !important">
                                    <div class="project-full-width__details-info-single">
                                        <h5 class="project-full-width__details-info-client">Project:</h5>
                                        <p class="project-full-width__details-info-name">Atlanta</p>
                                    </div>
                                    <div class="project-full-width__details-info-single">
                                        <h5 class="project-full-width__details-info-client">Area:</h5>
                                        <p class="project-full-width__details-info-name">Columbia, South Carolina</p>
                                    </div>
                                    <div class="project-full-width__details-info-single">
                                        <h5 class="project-full-width__details-info-client">Actual Man-hours:</h5>
                                        <p class="project-full-width__details-info-name">1,920 man-hours</p>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <!-- 3 -->
                        <div class="row mb-5">
                            <div class="col-xl-8">
                                <div class="">
                                    <h3 class="project-full-width__title">Atlanta</h3>
                                    <h5 class="project-full-width__details-info-client">Deliverables:</h5>
                                    <p class="project-full-width__text-1"> Completed  base  map  drawing  including  roads,  street  names,  curb  &  gutters, driveways, sidewalks and dimensions for the following area:
                                    </p>
                                    <ul>
                                        <li>Greenville – 138 miles covered
                                        </li>
                                        <li>Pickens County – 193 miles covered  </li>
                                    </ul>
                                </div>
                            </div>
                            <div class="col-xl-4">
                                <div class="project-full-width__details-info border p-4" style="border-bottom: 5px solid var(--thm-primary) !important">
                                    <div class="project-full-width__details-info-single">
                                        <h5 class="project-full-width__details-info-client">Project:</h5>
                                        <p class="project-full-width__details-info-name">Atlanta</p>
                                    </div>
                                    <div class="project-full-width__details-info-single">
                                        <h5 class="project-full-width__details-info-client">Area:</h5>
                                        <p class="project-full-width__details-info-name">Greenville, South Carolina
                                        </p>
                                    </div>
                                    <div class="project-full-width__details-info-single">
                                        <h5 class="project-full-width__details-info-client">Actual Man-hours:</h5>
                                        <p class="project-full-width__details-info-name">2,345 man-hours</p>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <!-- 4 -->
                        <div class="row mb-5">
                            <div class="col-xl-8">
                                <div class="">
                                    <h3 class="project-full-width__title">BTC (Brantley Telephone Company)</h3>
                                    <h5 class="project-full-width__details-info-client">Deliverables:</h5>
                                    <p class="project-full-width__text-1">Created the complete base map drawing requirement i.e. centerlines, right of way, C&G, road names and surfaces, and building structures, located in the State of Georgia.
                                    </p>
                                    <h5 class="project-full-width__details-info-client">Area:</h5>
                                    <ul>
                                        <li>Brantley area  – total  of  300-sheet  route for  Backbone GDOT,  Lake Paxton, Spring Lake, Pinckney Church and Camp Pinckney.
                                        </li>
                                        <li>Homeland area – total of 120-sheet route for fiber design run.  </li>
                                    </ul>
                                </div>
                            </div>
                            <div class="col-xl-4">
                                <div class="project-full-width__details-info border p-4" style="border-bottom: 5px solid var(--thm-primary) !important">
                                    <div class="project-full-width__details-info">
                                        <div class="project-full-width__details-info-single">
                                            <h5 class="project-full-width__details-info-client">Project:</h5>
                                            <p class="project-full-width__details-info-name">BTC (Brantley Telephone Company)</p>
                                        </div>
                                        <div class="project-full-width__details-info-single">
                                            <h5 class="project-full-width__details-info-client">Actual Man-hours:</h5>
                                            <p class="project-full-width__details-info-name">1,077 man-hours</p>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <!-- 5 -->
                        <div class="row mb-5">
                            <div class="col-xl-8">
                                <div class="">
                                    <h3 class="project-full-width__title">Gibson EMC
                                    </h3>
                                    <h5 class="project-full-width__details-info-client">Deliverables:</h5>
                                    <p class="project-full-width__text-1">Produced 4,451 drawing deliverables (11”x17” size drawing sheets) for Gibson EMC (Electric Membership Corporation) located in Tennessee. Scope of design work include are Viewport Creation, T1 and T2 Splitter placement, Fiber Count and As-built for the following areas:
                                    </p>
                                    <h5 class="project-full-width__details-info-client">Area:</h5>
                                    <ul>
                                        <li>Ridgely</li>
                                        <li>Mt Zion</li>
                                        <li>Rutherford</li>
                                        <li>Tiptonville</li>
                                        <li>Trenton Area South and North</li>
                                        <li>Gadsden Area</li>
                                    </ul>
                                </div>
                            </div>
                            <div class="col-xl-4">
                                <div class="project-full-width__details-info border p-4" style="border-bottom: 5px solid var(--thm-primary) !important">
                                    <div class="project-full-width__details-info">
                                        <div class="project-full-width__details-info-single">
                                            <h5 class="project-full-width__details-info-client">Project:</h5>
                                            <p class="project-full-width__details-info-name">Gibson EMC
                                            </p>
                                        </div>
                                        <div class="project-full-width__details-info-single">
                                            <h5 class="project-full-width__details-info-client">Actual Man-hours:</h5>
                                            <p class="project-full-width__details-info-name">5,373 man-hours</p>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <!-- 6 -->
                        <div class="row mb-5">
                            <div class="col-xl-8">
                                <div class="">
                                    <h3 class="project-full-width__title">Hargray
                                    </h3>
                                    <h5 class="project-full-width__details-info-client">Deliverables:</h5>
                                    <p class="project-full-width__text-1">Outlined and drawn layouts for roads, driveways, sidewalks, street names and FOC for Rockdale County, Newton County, Peachtree Corners, and Covington
                                        & Conyers situated in Georgia.
                                        </p>
                                    <h5 class="project-full-width__details-info-client">Area:</h5>
                                    <ul>
                                        <li>Rockdale County 48-mile long road
                                        </li>
                                        <li>Newton County 33-mile long road
                                        </li>
                                        <li>Peachtree Corners 10-mile long road
                                        </li>
                                        <li>Tiptonville</li>
                                        <li>Covington and Conyers 4.2-mile long road
                                        </li>
                                    </ul>
                                </div>
                            </div>
                            <div class="col-xl-4">
                                <div class="project-full-width__details-info border p-4" style="border-bottom: 5px solid var(--thm-primary) !important">
                                    <div class="project-full-width__details-info">
                                        <div class="project-full-width__details-info-single">
                                            <h5 class="project-full-width__details-info-client">Project:</h5>
                                            <p class="project-full-width__details-info-name">Hargray
                                            </p>
                                        </div>
                                        <div class="project-full-width__details-info-single">
                                            <h5 class="project-full-width__details-info-client">Actual Man-hours:</h5>
                                            <p class="project-full-width__details-info-name">957 man-hours</p>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>


                    </div>
                </section>

            </div>
        </div>
    </div>
</div>


<!-- project npc completed modal -->
<div class="modal fade" id="npcModal" tabindex="-1" aria-labelledby="npcModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-xl">
        <div class="modal-content rounded-0">
            <div class="modal-header border-0">
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
                
                <section class="project-full-width pt-0">
                    <div class="container">
                        <div class="text-end">
                            <img class="img-fluid" src="{{asset('/images/brand/brand-1-11.png')}}" alt="">
                        </div>
                        <div class="section-title text-center  mb-md-5">
                            <h2 class="section-title__title text-start mb-md-5 text-center">Projects Details</h2>
                        </div>

                        <!-- 7 -->
                        <div class="row mb-5">
                            <div class="col-xl-8">
                                <div class="">
                                    <h3 class="project-full-width__title">Small Cell, Alaska
                                    </h3>
                                    <h5 class="project-full-width__details-info-client">Deliverables:</h5>
                                    <p class="project-full-width__text-1">Accomplished the submission of poles for small cell towers, with different auxiliary attachments, situated in Anchorage, Alaska, and arrived in 100% completion as per Client’s requirement and engineering schedule for the following (147 Poles and 3,096 Sheets):
                                    </p>
                                    <h5 class="project-full-width__details-info-client">Poles:</h5>
                                    <ul>
                                        <li>ML&P poles – 35 plans with 735 sheets 
                                        </li>
                                        <li>CEA poles – 65 poles with 1,374 sheets 
                                        </li>
                                        <li>MOA poles – 47 plans with 987 sheets
                                        </li>
                                    </ul>
                                </div>
                            </div>
                            <div class="col-xl-4">
                                <div class="project-full-width__details-info border p-4" style="border-bottom: 5px solid var(--thm-primary) !important">
                                    <div class="project-full-width__details-info">
                                        <div class="project-full-width__details-info-single">
                                            <h5 class="project-full-width__details-info-client">Project:</h5>
                                            <p class="project-full-width__details-info-name">Small Cell, Alaska

                                            </p>
                                        </div>
                                        <div class="project-full-width__details-info-single">
                                            <h5 class="project-full-width__details-info-client">Actual Man-hours:</h5>
                                            <p class="project-full-width__details-info-name">1,567 man-hours</p>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        
                    </div>
                </section>

            </div>
        </div>
    </div>
</div>

<!-- project valard completed modal -->
<div class="modal fade" id="valardModal" tabindex="-1" aria-labelledby="valardModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-xl">
        <div class="modal-content rounded-0">
            <div class="modal-header border-0">
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
                
                <section class="project-full-width pt-0">
                    <div class="container">
                        <div class="text-end">
                            <img class="img-fluid" src="{{asset('/images/brand/brand-1-22.png')}}" alt="">
                        </div>
                        <div class="section-title text-center  mb-md-5">
                            <h2 class="section-title__title text-start mb-md-5 text-center">Projects Details</h2>
                        </div>

                        <!-- 8 -->
                        <div class="row mb-5">
                            <div class="col-xl-8">
                                <div class="">
                                    <h3 class="project-full-width__title">Bell, Canada
                                    </h3>
                                    <h5 class="project-full-width__details-info-client">Deliverables:</h5>
                                    <p class="project-full-width__text-1">Completed  a  total  of  40  FSAs  (Fiber  Serving  Area)  for  communities  located  in  Canada comprising   of   21,011-unit   residential   homes,   multi-dwelling   units,   and   commercial establishments  with  2,795  deliverables  (11”x17”  size  drawing  sheets)  produced  for Valard  Telecoms  particularly  Bell  FTTH  Projects.  The  scope  of  design  work  for  these communities include High Level Design, Permits, and the detailed 400 Series Drawings:
                                    </p>
                                    <h5 class="project-full-width__details-info-client">Area:</h5>
                                    <ul>
                                        <li>Brantford
                                        </li>
                                        <li>Tecumseh
                                        </li>
                                        <li>Tecumseh
                                        </li>
                                        <li>Amherstburg
                                        </li>
                                        <li>Lasalle
                                        </li>
                                        <li>Sarnia, Lochiel
                                        </li>
                                    </ul>
                                </div>
                            </div>
                            <div class="col-xl-4">
                                <div class="project-full-width__details-info border p-4" style="border-bottom: 5px solid var(--thm-primary) !important">
                                    <div class="project-full-width__details-info">
                                        <div class="project-full-width__details-info-single">
                                            <h5 class="project-full-width__details-info-client">Client:</h5>
                                            <p class="project-full-width__details-info-name">Bell, Canada
                                            </p>
                                        </div>
                                        <div class="project-full-width__details-info-single">
                                            <h5 class="project-full-width__details-info-client">Actual Man-hours:</h5>
                                            <p class="project-full-width__details-info-name">3,953 man-hours</p>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <!-- 9 -->
                        <div class="row mb-5">
                            <div class="col-xl-8">
                                <div class="">
                                    <h3 class="project-full-width__title">Shaw Communications / BNS Telecoms / Northwestel /
                                        Rogers Communications
                                    </h3>
                                    <h5 class="project-full-width__details-info-client">Deliverables:</h5>
                                    <p class="project-full-width__text-1">ULA, Utility Alignment Permit, drawings delivered from the above telecommunication Clients with 235 Homes Passed, and total of 442 sheets output.
                                    </p>
                                </div>
                            </div>
                            <div class="col-xl-4">
                                <div class="project-full-width__details-info border p-4" style="border-bottom: 5px solid var(--thm-primary) !important">
                                    <div class="project-full-width__details-info">
                                        <div class="project-full-width__details-info-single">
                                            <h5 class="project-full-width__details-info-client">Clients:</h5>
                                            <p class="project-full-width__details-info-name">Shaw Communications,
                                            </p>
                                            <p class="project-full-width__details-info-name">BNS Telecoms,
                                            </p>
                                            <p class="project-full-width__details-info-name">Northwestel,
                                            </p>
                                            <p class="project-full-width__details-info-name">Rogers Communications
                                            </p>
                                        </div>
                                        <div class="project-full-width__details-info-single">
                                            <h5 class="project-full-width__details-info-client">Actual Man-hours:</h5>
                                            <p class="project-full-width__details-info-name">1,106 man-hours</p>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        
                    </div>
                </section>

            </div>
        </div>
    </div>
</div>

<!-- project dr completed modal -->
<div class="modal fade" id="drModal" tabindex="-1" aria-labelledby="drModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-xl">
        <div class="modal-content rounded-0">
            <div class="modal-header border-0">
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
                
                <section class="project-full-width pt-0">
                    <div class="container">
                        <div class="text-end">
                            <img class="img-fluid" src="{{asset('/images/brand/brand-1-44.png')}}" alt="">
                        </div>
                        <div class="section-title text-center  mb-md-5">
                            <h2 class="section-title__title text-start mb-md-5 text-center">Projects Details</h2>
                        </div>

                        <!-- 10 -->
                        <div class="row mb-5">
                            <div class="col-xl-8">
                                <div class="">
                                    <h3 class="project-full-width__title">Lake Hancock Solar /
                                        Grange Hall Solar /
                                        Sun Stream Solar /
                                        Phoebe Substation
                                    </h3>
                                    <h5 class="project-full-width__details-info-client">Deliverables:</h5>
                                    <p class="project-full-width__text-1">Checked all IFR (Issued for Record) drawings i.e. one-line diagram, AC/DC schematics, internal/external wiring, and the like for electrical and instrument connection in the following substation: (Total of 507 sheets	- 11x17 examined )
                                    </p>
                                    <h5 class="project-full-width__details-info-client">Projects:</h5>
                                    <ul>
                                        <li>Lake Hancock Solar
                                        </li>
                                        <li>Grange Hall Solar
                                        </li>
                                        <li>Sun Stream Solar
                                        </li>
                                        <li>Phoebe Substation
                                        </li>
                                    </ul>
                                </div>
                            </div>
                            <div class="col-xl-4">
                                <div class="project-full-width__details-info border p-4" style="border-bottom: 5px solid var(--thm-primary) !important">
                                    <div class="project-full-width__details-info">
                                        <div class="project-full-width__details-info-single">
                                            <h5 class="project-full-width__details-info-client">Actual Man-hours:</h5>
                                            <p class="project-full-width__details-info-name">567 man-hours</p>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        
                    </div>
                </section>

            </div>
        </div>
    </div>
</div>

<!-- project qpse completed modal -->
<div class="modal fade" id="qpseModal" tabindex="-1" aria-labelledby="qpseModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-xl">
        <div class="modal-content rounded-0">
            <div class="modal-header border-0">
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
                
                <section class="project-full-width pt-0">
                    <div class="container">
                        <div class="text-end">
                            <img class="img-fluid" src="{{asset('/images/brand/brand-1-1414.p')}}ng" alt="">
                        </div>
                        <div class="section-title text-center  mb-md-5">
                            <h2 class="section-title__title text-start mb-md-5 text-center">Projects Details</h2>
                        </div>

                        <!-- 11 -->
                        <div class="row mb-5">
                            <div class="col-xl-8">
                                <div class="">
                                    <h3 class="project-full-width__title">Quanta Pipeline and Services Engineering
                                    </h3>
                                    <h5 class="project-full-width__details-info-client">Deliverables:</h5>
                                    <p class="project-full-width__text-1">Completed the As-built mechanical plans and details, P&ID drafting, ISO, and grounding plans for the QPSE counterpart:
                                    </p>
                                    <h5 class="project-full-width__details-info-client">Projects:</h5>
                                    <ul>
                                        <li>Summit Midstream – Blue Quail Station
                                        </li>
                                        <li>USA Compression – Station Energen Dickenson & Tiger
                                        </li>
                                        <li>MTS – As-built Model Revision
                                        </li>
                                        <li>USA Compression – Money Graham / Cypress / Pliny the Elder / Nailed it
                                        </li>
                                        <li>Kinder Morgan – Station 563 & 875
                                        </li>
                                        <li>Salt Creek – Coyote
                                        </li>
                                        <li>Salt Creek – Miso CS
                                        </li>
                                        <li>Salt Creek – Black Marlin
                                        </li>
                                        <li>USA – Pliny the Elder
                                        </li>
                                        <li>USA – OXY Salt Flats
                                        </li>
                                        <li>USA – Headwaters
                                        </li>
                                    </ul>
                                </div>
                            </div>
                            <div class="col-xl-4">
                                <div class="project-full-width__details-info border p-4" style="border-bottom: 5px solid var(--thm-primary) !important">
                                    <div class="project-full-width__details-info">
                                        <div class="project-full-width__details-info-single">
                                            <h5 class="project-full-width__details-info-client">Actual Man-hours:</h5>
                                            <!-- <p class="project-full-width__details-info-name">567 man-hours</p> -->
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        
                    </div>
                </section>

            </div>
        </div>
    </div>
</div>

<!-- project ucc completed modal -->
<div class="modal fade" id="uccModal" tabindex="-1" aria-labelledby="uccModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-xl">
        <div class="modal-content rounded-0">
            <div class="modal-header border-0">
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
                
                <section class="project-full-width pt-0">
                    <div class="container">
                        <div class="text-end">
                            <img class="img-fluid" src="{{asset('/images/brand/brand-1-66.png')}}" alt="">
                        </div>
                        <div class="section-title text-center  mb-md-5">
                            <h2 class="section-title__title text-start mb-md-5 text-center">Projects Details</h2>
                        </div>

                        <!-- 12 -->
                        <div class="row mb-5">
                            <div class="col-xl-8">
                                <div class="">
                                    <h3 class="project-full-width__title">Underground Construction Company, Inc
                                    </h3>
                                    <h5 class="project-full-width__details-info-client">Deliverables:</h5>
                                    <p class="project-full-width__text-1">Submitted the Overview and Location Maps for the following project name under UCCO counterpart:
                                    </p>
                                    <h5 class="project-full-width__details-info-client">Projects:</h5>
                                    <ul>
                                        <li>C-771 San Francisco (40 man-hours, 11 sheets)
                                        </li>
                                        <li>C-765 De Anza (40 man-hours, 8 sheets)
                                        </li>
                                        <li>C-769 Milpitas (40 man-hours, 8 sheets)
                                        </li>
                                        <li>C-768 Hollister (16 man-hours, 6 sheets)
                                        </li>
                                    </ul>
                                </div>
                            </div>
                            <div class="col-xl-4">
                                <div class="project-full-width__details-info border p-4" style="border-bottom: 5px solid var(--thm-primary) !important">
                                    <div class="project-full-width__details-info">
                                        <div class="project-full-width__details-info-single">
                                            <h5 class="project-full-width__details-info-client">Actual Man-hours:</h5>
                                            <!-- <p class="project-full-width__details-info-name">567 man-hours</p> -->
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <!-- 13 -->
                        <div class="row mb-5">
                            <div class="col-xl-8">
                                <div class="">
                                    <h3 class="project-full-width__title">Underground Construction Company, Inc
                                    </h3>
                                    <h5 class="project-full-width__details-info-client">Deliverables:</h5>
                                    <p class="project-full-width__text-1">Preparation of exhibit drawings for pipeline and right-of-way (ROW) permitting
                                    </p>
                                    <h5 class="project-full-width__details-info-client">Projects:</h5>
                                    <ul>
                                        <li>Modesto – Yosemite 
                                        </li>
                                        <li>Merced-Yosemite
                                        </li>
                                        <li>Kern 1

                                        </li>
                                        <li>Mojave</li>
                                        <li>Hinkley</li>
                                        <li>Humboldt 1
                                        </li>
                                        <li>Napa 1
                                        </li>
                                        <li>San Benito 1 </li>
                                        <li>Santa Clara </li>
                                        <li>Stanislaus</li>
                                        <li>Amador</li>
                                        <li>Fresno</li>
                                        <li>Humboldt 2
                                        </li>
                                        <li>Kern 2 </li>
                                        <li>Madera</li>
                                        <li>Marin</li>
                                        <li>Mendocino</li>
                                        <li>Merced</li>
                                        <li>Monterey</li>
                                        <li>Napa 2</li>
                                        <li>San Benito 2
                                        </li>
                                        <li>San Francisco 1 </li>
                                        <li>San Joaquin
                                        </li>
                                        <li>San Luis Obispo </li>
                                        <li>San Mateo </li>
                                        <li>Santa Clara </li>
                                        <li>Santa Cruz </li>
                                        <li>Solano</li>
                                        <li>Sonoma</li>
                                        <li>Stanislaus</li>
                                    </ul>
                                </div>
                            </div>
                            <div class="col-xl-4">
                                <div class="project-full-width__details-info border p-4" style="border-bottom: 5px solid var(--thm-primary) !important">
                                    <div class="project-full-width__details-info">
                                        <div class="project-full-width__details-info-single">
                                            <h5 class="project-full-width__details-info-client">Actual Man-hours:</h5>
                                            <!-- <p class="project-full-width__details-info-name">567 man-hours</p> -->
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        
                    </div>
                </section>

            </div>
        </div>
    </div>
</div>

<!-- project pes completed modal -->
<div class="modal fade" id="pesModal" tabindex="-1" aria-labelledby="pesModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-xl">
        <div class="modal-content rounded-0">
            <div class="modal-header border-0">
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
                
                <section class="project-full-width pt-0">
                    <div class="container">
                        <div class="text-end">
                            <img class="img-fluid" src="{{asset('/images/brand/brand-1-99.png')}}" alt="">
                        </div>
                        <div class="section-title text-center  mb-md-5">
                            <h2 class="section-title__title text-start mb-md-5 text-center">Projects Details</h2>
                        </div>

                        <!-- 14 -->
                        <div class="row mb-5">
                            <div class="col-xl-8">
                                <div class="">
                                    <h3 class="project-full-width__title">Performance Energy Services
                                    </h3>
                                    <p class="project-full-width__text-1">Deployed Work pack engineer in off-shore of Israel for the Leviathan project, which is the largest energy project in the State of Israel to deliver commercial gas sales to its domestic and regional markets, for the following job involvement:
                                    </p>
                                    <h5 class="project-full-width__details-info-client">Scope of Work:</h5>
                                    <ul>
                                        <li>Monitoring status of the pre-developed work packages during the hook-up/ construction stage.

                                        </li>
                                        <li>Preparing Site Instructions whenever required for the construction.

                                        </li>
                                        <li>Keeping track on offshore construction materials availability with onshore counterparts.

                                        </li>
                                        <li>Updating & submitting Daily Construction Progress Reports, PES Crew Daily Project Timesheet and General Personnel-On-Board Report.
                                        </li>
                                        <li>Maintaining all Records & Documents which are to be submitted at the conclusion of
                                            the project.
                                        </li>
                                    </ul>
                                </div>
                            </div>
                            <div class="col-xl-4">
                                <div class="project-full-width__details-info border p-4" style="border-bottom: 5px solid var(--thm-primary) !important">
                                    <div class="project-full-width__details-info">
                                        <div class="project-full-width__details-info-single">
                                            <h5 class="project-full-width__details-info-client">Actual Man-hours:</h5>
                                            <!-- <p class="project-full-width__details-info-name">567 man-hours</p> -->
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        
                    </div>
                </section>

            </div>
        </div>
    </div>
</div>
@endsection

@section('js')
<script>
    $('.modal-btn').click(function() {
        // alert()
        $("#content").html($(this).data("content"))
    });
</script>
@endsection
