<?php

namespace App\Models\Events;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Spatie\Searchable\Searchable;
use Spatie\Searchable\SearchResult;

class Event extends Model implements Searchable
{
    use HasFactory;

    protected $fillable = [
    	'tag_id', 'title', 'image', 'description'
    ];

    public function getSearchResult(): SearchResult
     {
        $url = route('events_details', str_replace([' ', '/'], ['_', '`'], $this->title));
     
         return new \Spatie\Searchable\SearchResult(
            $this,
            $this->title,
            $url
         );
     }
}
