<?php

namespace App\Http\Controllers\Admin\Page;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Newsletter;
use Validator;

class NewsletterController extends Controller
{
    
    public function index()
    {
        $data = Newsletter::latest()->get();
        return view('module.newsletter.index', compact('data'));
    }

    
    public function store(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'email' => ['required', 'string', 'email', 'max:255'],
        ]);

        if($validator->fails()){
            return back()->withInput()->withErrors($validator);
        }

        Newsletter::create([
            'email' => $request->email,
        ]);

        return back()->with('message', 'Thank you for subscribing to us. We will update you through your email.');
    }

    
    public function destroy($id)
    {
        Newsletter::findOrFail($id)->delete();
        return back()->with('success', 'Successfully deleted newsletter');
    }
}
