<?php

namespace App\Http\Controllers\Admin\Page;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;

class CategoryController extends Controller
{
    public function index()
    {
        $data = Category::latest()->get();
        return view('module.category.index', compact('data'));
    }

    
    public function store(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'name' => ['required', 'string', 'max:255'],
        ]);

        if($validator->fails()){
            return back()->withInput()->withErrors($validator);
        }

        Category::create([
            'name' => $request->name,
        ]);

        return back()->with('success', 'Successfully added new category');
    }

    
    public function show($id)
    {
        //
    }

    
    public function edit($id)
    {
        //
    }

    
    public function update(Request $request, $id)
    {
        $validator = Validator::make($request->all(), [
            'name' => ['required', 'string', 'max:255'],
        ]);

        if($validator->fails()){
            return back()->withInput()->withErrors($validator);
        }

        $category = Category::findOrFail($id);
        $category->name = $request->name;
        $category->save();

        return back()->with('success', 'Successfully updated category');
    }

    
    public function destroy($id)
    {
        $category = Category::findOrFail($id)->delete();
        return back()->with('success', 'Successfully deleted category');
    }
}
